package zio.aws.neptune.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CharacterSet(
    characterSetName: Optional[String] = Optional.Absent,
    characterSetDescription: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.neptune.model.CharacterSet = {
    import CharacterSet.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.neptune.model.CharacterSet
      .builder()
      .optionallyWith(characterSetName.map(value => value: java.lang.String))(
        _.characterSetName
      )
      .optionallyWith(
        characterSetDescription.map(value => value: java.lang.String)
      )(_.characterSetDescription)
      .build()
  }
  def asReadOnly: zio.aws.neptune.model.CharacterSet.ReadOnly =
    zio.aws.neptune.model.CharacterSet.wrap(buildAwsValue())
}
object CharacterSet {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.neptune.model.CharacterSet
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.neptune.model.CharacterSet =
      zio.aws.neptune.model.CharacterSet(
        characterSetName.map(value => value),
        characterSetDescription.map(value => value)
      )
    def characterSetName: Optional[String]
    def characterSetDescription: Optional[String]
    def getCharacterSetName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("characterSetName", characterSetName)
    def getCharacterSetDescription: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("characterSetDescription", characterSetDescription)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.neptune.model.CharacterSet
  ) extends zio.aws.neptune.model.CharacterSet.ReadOnly {
    override val characterSetName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.characterSetName())
      .map(value => value: String)
    override val characterSetDescription: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.characterSetDescription())
        .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.neptune.model.CharacterSet
  ): zio.aws.neptune.model.CharacterSet.ReadOnly = new Wrapper(impl)
}
