package zio.aws.neptune.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateDbClusterParameterGroupResponse(
    dbClusterParameterGroup: Optional[
      zio.aws.neptune.model.DBClusterParameterGroup
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.neptune.model.CreateDbClusterParameterGroupResponse = {
    import CreateDbClusterParameterGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.neptune.model.CreateDbClusterParameterGroupResponse
      .builder()
      .optionallyWith(
        dbClusterParameterGroup.map(value => value.buildAwsValue())
      )(_.dbClusterParameterGroup)
      .build()
  }
  def asReadOnly
      : zio.aws.neptune.model.CreateDbClusterParameterGroupResponse.ReadOnly =
    zio.aws.neptune.model.CreateDbClusterParameterGroupResponse
      .wrap(buildAwsValue())
}
object CreateDbClusterParameterGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.neptune.model.CreateDbClusterParameterGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.neptune.model.CreateDbClusterParameterGroupResponse =
      zio.aws.neptune.model.CreateDbClusterParameterGroupResponse(
        dbClusterParameterGroup.map(value => value.asEditable)
      )
    def dbClusterParameterGroup
        : Optional[zio.aws.neptune.model.DBClusterParameterGroup.ReadOnly]
    def getDbClusterParameterGroup: ZIO[
      Any,
      AwsError,
      zio.aws.neptune.model.DBClusterParameterGroup.ReadOnly
    ] = AwsError.unwrapOptionField(
      "dbClusterParameterGroup",
      dbClusterParameterGroup
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.neptune.model.CreateDbClusterParameterGroupResponse
  ) extends zio.aws.neptune.model.CreateDbClusterParameterGroupResponse.ReadOnly {
    override val dbClusterParameterGroup
        : Optional[zio.aws.neptune.model.DBClusterParameterGroup.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbClusterParameterGroup())
        .map(value => zio.aws.neptune.model.DBClusterParameterGroup.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.neptune.model.CreateDbClusterParameterGroupResponse
  ): zio.aws.neptune.model.CreateDbClusterParameterGroupResponse.ReadOnly =
    new Wrapper(impl)
}
