package zio.aws.neptune.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DBEngineVersion(
    engine: Optional[String] = Optional.Absent,
    engineVersion: Optional[String] = Optional.Absent,
    dbParameterGroupFamily: Optional[String] = Optional.Absent,
    dbEngineDescription: Optional[String] = Optional.Absent,
    dbEngineVersionDescription: Optional[String] = Optional.Absent,
    defaultCharacterSet: Optional[zio.aws.neptune.model.CharacterSet] =
      Optional.Absent,
    supportedCharacterSets: Optional[
      Iterable[zio.aws.neptune.model.CharacterSet]
    ] = Optional.Absent,
    validUpgradeTarget: Optional[
      Iterable[zio.aws.neptune.model.UpgradeTarget]
    ] = Optional.Absent,
    supportedTimezones: Optional[Iterable[zio.aws.neptune.model.Timezone]] =
      Optional.Absent,
    exportableLogTypes: Optional[Iterable[String]] = Optional.Absent,
    supportsLogExportsToCloudwatchLogs: Optional[Boolean] = Optional.Absent,
    supportsReadReplica: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.neptune.model.DBEngineVersion = {
    import DBEngineVersion.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.neptune.model.DBEngineVersion
      .builder()
      .optionallyWith(engine.map(value => value: java.lang.String))(_.engine)
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(
        dbParameterGroupFamily.map(value => value: java.lang.String)
      )(_.dbParameterGroupFamily)
      .optionallyWith(
        dbEngineDescription.map(value => value: java.lang.String)
      )(_.dbEngineDescription)
      .optionallyWith(
        dbEngineVersionDescription.map(value => value: java.lang.String)
      )(_.dbEngineVersionDescription)
      .optionallyWith(defaultCharacterSet.map(value => value.buildAwsValue()))(
        _.defaultCharacterSet
      )
      .optionallyWith(
        supportedCharacterSets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.supportedCharacterSets)
      .optionallyWith(
        validUpgradeTarget.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.validUpgradeTarget)
      .optionallyWith(
        supportedTimezones.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.supportedTimezones)
      .optionallyWith(
        exportableLogTypes.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.exportableLogTypes)
      .optionallyWith(
        supportsLogExportsToCloudwatchLogs.map(value =>
          value: java.lang.Boolean
        )
      )(_.supportsLogExportsToCloudwatchLogs)
      .optionallyWith(
        supportsReadReplica.map(value => value: java.lang.Boolean)
      )(_.supportsReadReplica)
      .build()
  }
  def asReadOnly: zio.aws.neptune.model.DBEngineVersion.ReadOnly =
    zio.aws.neptune.model.DBEngineVersion.wrap(buildAwsValue())
}
object DBEngineVersion {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.neptune.model.DBEngineVersion
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.neptune.model.DBEngineVersion =
      zio.aws.neptune.model.DBEngineVersion(
        engine.map(value => value),
        engineVersion.map(value => value),
        dbParameterGroupFamily.map(value => value),
        dbEngineDescription.map(value => value),
        dbEngineVersionDescription.map(value => value),
        defaultCharacterSet.map(value => value.asEditable),
        supportedCharacterSets.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        validUpgradeTarget.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        supportedTimezones.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        exportableLogTypes.map(value => value),
        supportsLogExportsToCloudwatchLogs.map(value => value),
        supportsReadReplica.map(value => value)
      )
    def engine: Optional[String]
    def engineVersion: Optional[String]
    def dbParameterGroupFamily: Optional[String]
    def dbEngineDescription: Optional[String]
    def dbEngineVersionDescription: Optional[String]
    def defaultCharacterSet
        : Optional[zio.aws.neptune.model.CharacterSet.ReadOnly]
    def supportedCharacterSets
        : Optional[List[zio.aws.neptune.model.CharacterSet.ReadOnly]]
    def validUpgradeTarget
        : Optional[List[zio.aws.neptune.model.UpgradeTarget.ReadOnly]]
    def supportedTimezones
        : Optional[List[zio.aws.neptune.model.Timezone.ReadOnly]]
    def exportableLogTypes: Optional[List[String]]
    def supportsLogExportsToCloudwatchLogs: Optional[Boolean]
    def supportsReadReplica: Optional[Boolean]
    def getEngine: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engine", engine)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getDbParameterGroupFamily: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("dbParameterGroupFamily", dbParameterGroupFamily)
    def getDbEngineDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbEngineDescription", dbEngineDescription)
    def getDbEngineVersionDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "dbEngineVersionDescription",
        dbEngineVersionDescription
      )
    def getDefaultCharacterSet
        : ZIO[Any, AwsError, zio.aws.neptune.model.CharacterSet.ReadOnly] =
      AwsError.unwrapOptionField("defaultCharacterSet", defaultCharacterSet)
    def getSupportedCharacterSets: ZIO[Any, AwsError, List[
      zio.aws.neptune.model.CharacterSet.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "supportedCharacterSets",
      supportedCharacterSets
    )
    def getValidUpgradeTarget: ZIO[Any, AwsError, List[
      zio.aws.neptune.model.UpgradeTarget.ReadOnly
    ]] = AwsError.unwrapOptionField("validUpgradeTarget", validUpgradeTarget)
    def getSupportedTimezones
        : ZIO[Any, AwsError, List[zio.aws.neptune.model.Timezone.ReadOnly]] =
      AwsError.unwrapOptionField("supportedTimezones", supportedTimezones)
    def getExportableLogTypes: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("exportableLogTypes", exportableLogTypes)
    def getSupportsLogExportsToCloudwatchLogs: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "supportsLogExportsToCloudwatchLogs",
        supportsLogExportsToCloudwatchLogs
      )
    def getSupportsReadReplica: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("supportsReadReplica", supportsReadReplica)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.neptune.model.DBEngineVersion
  ) extends zio.aws.neptune.model.DBEngineVersion.ReadOnly {
    override val engine: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engine())
      .map(value => value: String)
    override val engineVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engineVersion())
      .map(value => value: String)
    override val dbParameterGroupFamily: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbParameterGroupFamily())
        .map(value => value: String)
    override val dbEngineDescription: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbEngineDescription())
      .map(value => value: String)
    override val dbEngineVersionDescription: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbEngineVersionDescription())
        .map(value => value: String)
    override val defaultCharacterSet
        : Optional[zio.aws.neptune.model.CharacterSet.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaultCharacterSet())
        .map(value => zio.aws.neptune.model.CharacterSet.wrap(value))
    override val supportedCharacterSets
        : Optional[List[zio.aws.neptune.model.CharacterSet.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.supportedCharacterSets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.neptune.model.CharacterSet.wrap(item)
          }.toList
        )
    override val validUpgradeTarget
        : Optional[List[zio.aws.neptune.model.UpgradeTarget.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.validUpgradeTarget())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.neptune.model.UpgradeTarget.wrap(item)
          }.toList
        )
    override val supportedTimezones
        : Optional[List[zio.aws.neptune.model.Timezone.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.supportedTimezones())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.neptune.model.Timezone.wrap(item)
          }.toList
        )
    override val exportableLogTypes: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.exportableLogTypes())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val supportsLogExportsToCloudwatchLogs: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.supportsLogExportsToCloudwatchLogs())
        .map(value => value: Boolean)
    override val supportsReadReplica: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.supportsReadReplica())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.neptune.model.DBEngineVersion
  ): zio.aws.neptune.model.DBEngineVersion.ReadOnly = new Wrapper(impl)
}
