package zio.aws.neptune.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteDbInstanceRequest(
    dbInstanceIdentifier: String,
    skipFinalSnapshot: Optional[Boolean] = Optional.Absent,
    finalDBSnapshotIdentifier: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.neptune.model.DeleteDbInstanceRequest = {
    import DeleteDbInstanceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.neptune.model.DeleteDbInstanceRequest
      .builder()
      .dbInstanceIdentifier(dbInstanceIdentifier: java.lang.String)
      .optionallyWith(skipFinalSnapshot.map(value => value: java.lang.Boolean))(
        _.skipFinalSnapshot
      )
      .optionallyWith(
        finalDBSnapshotIdentifier.map(value => value: java.lang.String)
      )(_.finalDBSnapshotIdentifier)
      .build()
  }
  def asReadOnly: zio.aws.neptune.model.DeleteDbInstanceRequest.ReadOnly =
    zio.aws.neptune.model.DeleteDbInstanceRequest.wrap(buildAwsValue())
}
object DeleteDbInstanceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.neptune.model.DeleteDbInstanceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.neptune.model.DeleteDbInstanceRequest =
      zio.aws.neptune.model.DeleteDbInstanceRequest(
        dbInstanceIdentifier,
        skipFinalSnapshot.map(value => value),
        finalDBSnapshotIdentifier.map(value => value)
      )
    def dbInstanceIdentifier: String
    def skipFinalSnapshot: Optional[Boolean]
    def finalDBSnapshotIdentifier: Optional[String]
    def getDbInstanceIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbInstanceIdentifier)
    def getSkipFinalSnapshot: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("skipFinalSnapshot", skipFinalSnapshot)
    def getFinalDBSnapshotIdentifier: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("finalDBSnapshotIdentifier", finalDBSnapshotIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.neptune.model.DeleteDbInstanceRequest
  ) extends zio.aws.neptune.model.DeleteDbInstanceRequest.ReadOnly {
    override val dbInstanceIdentifier: String =
      impl.dbInstanceIdentifier(): String
    override val skipFinalSnapshot: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.skipFinalSnapshot())
      .map(value => value: Boolean)
    override val finalDBSnapshotIdentifier: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.finalDBSnapshotIdentifier())
        .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.neptune.model.DeleteDbInstanceRequest
  ): zio.aws.neptune.model.DeleteDbInstanceRequest.ReadOnly = new Wrapper(impl)
}
