package zio.aws.neptune.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeDbClusterSnapshotsResponse(
    marker: Optional[String] = Optional.Absent,
    dbClusterSnapshots: Optional[
      Iterable[zio.aws.neptune.model.DBClusterSnapshot]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.neptune.model.DescribeDbClusterSnapshotsResponse = {
    import DescribeDbClusterSnapshotsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.neptune.model.DescribeDbClusterSnapshotsResponse
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        dbClusterSnapshots.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dbClusterSnapshots)
      .build()
  }
  def asReadOnly
      : zio.aws.neptune.model.DescribeDbClusterSnapshotsResponse.ReadOnly =
    zio.aws.neptune.model.DescribeDbClusterSnapshotsResponse
      .wrap(buildAwsValue())
}
object DescribeDbClusterSnapshotsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.neptune.model.DescribeDbClusterSnapshotsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.neptune.model.DescribeDbClusterSnapshotsResponse =
      zio.aws.neptune.model.DescribeDbClusterSnapshotsResponse(
        marker.map(value => value),
        dbClusterSnapshots.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def marker: Optional[String]
    def dbClusterSnapshots
        : Optional[List[zio.aws.neptune.model.DBClusterSnapshot.ReadOnly]]
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getDbClusterSnapshots: ZIO[Any, AwsError, List[
      zio.aws.neptune.model.DBClusterSnapshot.ReadOnly
    ]] = AwsError.unwrapOptionField("dbClusterSnapshots", dbClusterSnapshots)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.neptune.model.DescribeDbClusterSnapshotsResponse
  ) extends zio.aws.neptune.model.DescribeDbClusterSnapshotsResponse.ReadOnly {
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
    override val dbClusterSnapshots
        : Optional[List[zio.aws.neptune.model.DBClusterSnapshot.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbClusterSnapshots())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.neptune.model.DBClusterSnapshot.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.neptune.model.DescribeDbClusterSnapshotsResponse
  ): zio.aws.neptune.model.DescribeDbClusterSnapshotsResponse.ReadOnly =
    new Wrapper(impl)
}
