package zio.aws.neptune.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeDbClustersResponse(
    marker: Optional[String] = Optional.Absent,
    dbClusters: Optional[Iterable[zio.aws.neptune.model.DBCluster]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.neptune.model.DescribeDbClustersResponse = {
    import DescribeDbClustersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.neptune.model.DescribeDbClustersResponse
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        dbClusters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dbClusters)
      .build()
  }
  def asReadOnly: zio.aws.neptune.model.DescribeDbClustersResponse.ReadOnly =
    zio.aws.neptune.model.DescribeDbClustersResponse.wrap(buildAwsValue())
}
object DescribeDbClustersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.neptune.model.DescribeDbClustersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.neptune.model.DescribeDbClustersResponse =
      zio.aws.neptune.model.DescribeDbClustersResponse(
        marker.map(value => value),
        dbClusters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def marker: Optional[String]
    def dbClusters: Optional[List[zio.aws.neptune.model.DBCluster.ReadOnly]]
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getDbClusters
        : ZIO[Any, AwsError, List[zio.aws.neptune.model.DBCluster.ReadOnly]] =
      AwsError.unwrapOptionField("dbClusters", dbClusters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.neptune.model.DescribeDbClustersResponse
  ) extends zio.aws.neptune.model.DescribeDbClustersResponse.ReadOnly {
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
    override val dbClusters
        : Optional[List[zio.aws.neptune.model.DBCluster.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbClusters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.neptune.model.DBCluster.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.neptune.model.DescribeDbClustersResponse
  ): zio.aws.neptune.model.DescribeDbClustersResponse.ReadOnly = new Wrapper(
    impl
  )
}
