package zio.aws.neptune.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeOrderableDbInstanceOptionsResponse(
    orderableDBInstanceOptions: Optional[
      Iterable[zio.aws.neptune.model.OrderableDBInstanceOption]
    ] = Optional.Absent,
    marker: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.neptune.model.DescribeOrderableDbInstanceOptionsResponse = {
    import DescribeOrderableDbInstanceOptionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.neptune.model.DescribeOrderableDbInstanceOptionsResponse
      .builder()
      .optionallyWith(
        orderableDBInstanceOptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.orderableDBInstanceOptions)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.neptune.model.DescribeOrderableDbInstanceOptionsResponse.ReadOnly =
    zio.aws.neptune.model.DescribeOrderableDbInstanceOptionsResponse
      .wrap(buildAwsValue())
}
object DescribeOrderableDbInstanceOptionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.neptune.model.DescribeOrderableDbInstanceOptionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.neptune.model.DescribeOrderableDbInstanceOptionsResponse =
      zio.aws.neptune.model.DescribeOrderableDbInstanceOptionsResponse(
        orderableDBInstanceOptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        marker.map(value => value)
      )
    def orderableDBInstanceOptions: Optional[
      List[zio.aws.neptune.model.OrderableDBInstanceOption.ReadOnly]
    ]
    def marker: Optional[String]
    def getOrderableDBInstanceOptions: ZIO[Any, AwsError, List[
      zio.aws.neptune.model.OrderableDBInstanceOption.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "orderableDBInstanceOptions",
      orderableDBInstanceOptions
    )
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.neptune.model.DescribeOrderableDbInstanceOptionsResponse
  ) extends zio.aws.neptune.model.DescribeOrderableDbInstanceOptionsResponse.ReadOnly {
    override val orderableDBInstanceOptions: Optional[
      List[zio.aws.neptune.model.OrderableDBInstanceOption.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.orderableDBInstanceOptions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.neptune.model.OrderableDBInstanceOption.wrap(item)
        }.toList
      )
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.neptune.model.DescribeOrderableDbInstanceOptionsResponse
  ): zio.aws.neptune.model.DescribeOrderableDbInstanceOptionsResponse.ReadOnly =
    new Wrapper(impl)
}
