package zio.aws.neptune.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeValidDbInstanceModificationsRequest(
    dbInstanceIdentifier: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.neptune.model.DescribeValidDbInstanceModificationsRequest = {
    import DescribeValidDbInstanceModificationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.neptune.model.DescribeValidDbInstanceModificationsRequest
      .builder()
      .dbInstanceIdentifier(dbInstanceIdentifier: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.neptune.model.DescribeValidDbInstanceModificationsRequest.ReadOnly =
    zio.aws.neptune.model.DescribeValidDbInstanceModificationsRequest
      .wrap(buildAwsValue())
}
object DescribeValidDbInstanceModificationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.neptune.model.DescribeValidDbInstanceModificationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.neptune.model.DescribeValidDbInstanceModificationsRequest =
      zio.aws.neptune.model
        .DescribeValidDbInstanceModificationsRequest(dbInstanceIdentifier)
    def dbInstanceIdentifier: String
    def getDbInstanceIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbInstanceIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.neptune.model.DescribeValidDbInstanceModificationsRequest
  ) extends zio.aws.neptune.model.DescribeValidDbInstanceModificationsRequest.ReadOnly {
    override val dbInstanceIdentifier: String =
      impl.dbInstanceIdentifier(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.neptune.model.DescribeValidDbInstanceModificationsRequest
  ): zio.aws.neptune.model.DescribeValidDbInstanceModificationsRequest.ReadOnly =
    new Wrapper(impl)
}
