package zio.aws.neptune.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListTagsForResourceRequest(
    resourceName: String,
    filters: Optional[Iterable[zio.aws.neptune.model.Filter]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.neptune.model.ListTagsForResourceRequest = {
    import ListTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.neptune.model.ListTagsForResourceRequest
      .builder()
      .resourceName(resourceName: java.lang.String)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .build()
  }
  def asReadOnly: zio.aws.neptune.model.ListTagsForResourceRequest.ReadOnly =
    zio.aws.neptune.model.ListTagsForResourceRequest.wrap(buildAwsValue())
}
object ListTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.neptune.model.ListTagsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.neptune.model.ListTagsForResourceRequest =
      zio.aws.neptune.model.ListTagsForResourceRequest(
        resourceName,
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def resourceName: String
    def filters: Optional[List[zio.aws.neptune.model.Filter.ReadOnly]]
    def getResourceName: ZIO[Any, Nothing, String] = ZIO.succeed(resourceName)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.neptune.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.neptune.model.ListTagsForResourceRequest
  ) extends zio.aws.neptune.model.ListTagsForResourceRequest.ReadOnly {
    override val resourceName: String = impl.resourceName(): String
    override val filters
        : Optional[List[zio.aws.neptune.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.neptune.model.Filter.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.neptune.model.ListTagsForResourceRequest
  ): zio.aws.neptune.model.ListTagsForResourceRequest.ReadOnly = new Wrapper(
    impl
  )
}
