package zio.aws.neptune.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ModifyDbClusterParameterGroupRequest(
    dbClusterParameterGroupName: String,
    parameters: Iterable[zio.aws.neptune.model.Parameter]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.neptune.model.ModifyDbClusterParameterGroupRequest = {
    import ModifyDbClusterParameterGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.neptune.model.ModifyDbClusterParameterGroupRequest
      .builder()
      .dbClusterParameterGroupName(
        dbClusterParameterGroupName: java.lang.String
      )
      .parameters(parameters.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.neptune.model.ModifyDbClusterParameterGroupRequest.ReadOnly =
    zio.aws.neptune.model.ModifyDbClusterParameterGroupRequest
      .wrap(buildAwsValue())
}
object ModifyDbClusterParameterGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.neptune.model.ModifyDbClusterParameterGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.neptune.model.ModifyDbClusterParameterGroupRequest =
      zio.aws.neptune.model.ModifyDbClusterParameterGroupRequest(
        dbClusterParameterGroupName,
        parameters.map { item =>
          item.asEditable
        }
      )
    def dbClusterParameterGroupName: String
    def parameters: List[zio.aws.neptune.model.Parameter.ReadOnly]
    def getDbClusterParameterGroupName: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbClusterParameterGroupName)
    def getParameters
        : ZIO[Any, Nothing, List[zio.aws.neptune.model.Parameter.ReadOnly]] =
      ZIO.succeed(parameters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.neptune.model.ModifyDbClusterParameterGroupRequest
  ) extends zio.aws.neptune.model.ModifyDbClusterParameterGroupRequest.ReadOnly {
    override val dbClusterParameterGroupName: String =
      impl.dbClusterParameterGroupName(): String
    override val parameters: List[zio.aws.neptune.model.Parameter.ReadOnly] =
      impl
        .parameters()
        .asScala
        .map { item =>
          zio.aws.neptune.model.Parameter.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.neptune.model.ModifyDbClusterParameterGroupRequest
  ): zio.aws.neptune.model.ModifyDbClusterParameterGroupRequest.ReadOnly =
    new Wrapper(impl)
}
