package zio.aws.neptune.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.neptune.model.primitives.{IntegerOptional, Integer}
import scala.jdk.CollectionConverters._
final case class Range(
    from: Optional[Integer] = Optional.Absent,
    to: Optional[Integer] = Optional.Absent,
    step: Optional[IntegerOptional] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.neptune.model.Range = {
    import Range.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.neptune.model.Range
      .builder()
      .optionallyWith(from.map(value => value: java.lang.Integer))(_.from)
      .optionallyWith(to.map(value => value: java.lang.Integer))(_.to)
      .optionallyWith(step.map(value => value: java.lang.Integer))(_.step)
      .build()
  }
  def asReadOnly: zio.aws.neptune.model.Range.ReadOnly =
    zio.aws.neptune.model.Range.wrap(buildAwsValue())
}
object Range {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.neptune.model.Range] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.neptune.model.Range = zio.aws.neptune.model.Range(
      from.map(value => value),
      to.map(value => value),
      step.map(value => value)
    )
    def from: Optional[Integer]
    def to: Optional[Integer]
    def step: Optional[IntegerOptional]
    def getFrom: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("from", from)
    def getTo: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("to", to)
    def getStep: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("step", step)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.neptune.model.Range
  ) extends zio.aws.neptune.model.Range.ReadOnly {
    override val from: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.from())
      .map(value => value: Integer)
    override val to: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.to())
      .map(value => value: Integer)
    override val step: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.step())
      .map(value => value: IntegerOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.neptune.model.Range
  ): zio.aws.neptune.model.Range.ReadOnly = new Wrapper(impl)
}
