package zio.aws.neptune.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.neptune.model.primitives.BooleanOptional
import scala.jdk.CollectionConverters._
final case class RebootDbInstanceRequest(
    dbInstanceIdentifier: String,
    forceFailover: Optional[BooleanOptional] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.neptune.model.RebootDbInstanceRequest = {
    import RebootDbInstanceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.neptune.model.RebootDbInstanceRequest
      .builder()
      .dbInstanceIdentifier(dbInstanceIdentifier: java.lang.String)
      .optionallyWith(forceFailover.map(value => value: java.lang.Boolean))(
        _.forceFailover
      )
      .build()
  }
  def asReadOnly: zio.aws.neptune.model.RebootDbInstanceRequest.ReadOnly =
    zio.aws.neptune.model.RebootDbInstanceRequest.wrap(buildAwsValue())
}
object RebootDbInstanceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.neptune.model.RebootDbInstanceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.neptune.model.RebootDbInstanceRequest =
      zio.aws.neptune.model.RebootDbInstanceRequest(
        dbInstanceIdentifier,
        forceFailover.map(value => value)
      )
    def dbInstanceIdentifier: String
    def forceFailover: Optional[BooleanOptional]
    def getDbInstanceIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbInstanceIdentifier)
    def getForceFailover: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("forceFailover", forceFailover)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.neptune.model.RebootDbInstanceRequest
  ) extends zio.aws.neptune.model.RebootDbInstanceRequest.ReadOnly {
    override val dbInstanceIdentifier: String =
      impl.dbInstanceIdentifier(): String
    override val forceFailover: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.forceFailover())
        .map(value => value: BooleanOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.neptune.model.RebootDbInstanceRequest
  ): zio.aws.neptune.model.RebootDbInstanceRequest.ReadOnly = new Wrapper(impl)
}
