package zio.aws.neptune.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RemoveRoleFromDbClusterRequest(
    dbClusterIdentifier: String,
    roleArn: String,
    featureName: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.neptune.model.RemoveRoleFromDbClusterRequest = {
    import RemoveRoleFromDbClusterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.neptune.model.RemoveRoleFromDbClusterRequest
      .builder()
      .dbClusterIdentifier(dbClusterIdentifier: java.lang.String)
      .roleArn(roleArn: java.lang.String)
      .optionallyWith(featureName.map(value => value: java.lang.String))(
        _.featureName
      )
      .build()
  }
  def asReadOnly
      : zio.aws.neptune.model.RemoveRoleFromDbClusterRequest.ReadOnly =
    zio.aws.neptune.model.RemoveRoleFromDbClusterRequest.wrap(buildAwsValue())
}
object RemoveRoleFromDbClusterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.neptune.model.RemoveRoleFromDbClusterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.neptune.model.RemoveRoleFromDbClusterRequest =
      zio.aws.neptune.model.RemoveRoleFromDbClusterRequest(
        dbClusterIdentifier,
        roleArn,
        featureName.map(value => value)
      )
    def dbClusterIdentifier: String
    def roleArn: String
    def featureName: Optional[String]
    def getDbClusterIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbClusterIdentifier)
    def getRoleArn: ZIO[Any, Nothing, String] = ZIO.succeed(roleArn)
    def getFeatureName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("featureName", featureName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.neptune.model.RemoveRoleFromDbClusterRequest
  ) extends zio.aws.neptune.model.RemoveRoleFromDbClusterRequest.ReadOnly {
    override val dbClusterIdentifier: String =
      impl.dbClusterIdentifier(): String
    override val roleArn: String = impl.roleArn(): String
    override val featureName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.featureName())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.neptune.model.RemoveRoleFromDbClusterRequest
  ): zio.aws.neptune.model.RemoveRoleFromDbClusterRequest.ReadOnly =
    new Wrapper(impl)
}
