package zio.aws.neptune.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RestoreDbClusterFromSnapshotResponse(
    dbCluster: Optional[zio.aws.neptune.model.DBCluster] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.neptune.model.RestoreDbClusterFromSnapshotResponse = {
    import RestoreDbClusterFromSnapshotResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.neptune.model.RestoreDbClusterFromSnapshotResponse
      .builder()
      .optionallyWith(dbCluster.map(value => value.buildAwsValue()))(
        _.dbCluster
      )
      .build()
  }
  def asReadOnly
      : zio.aws.neptune.model.RestoreDbClusterFromSnapshotResponse.ReadOnly =
    zio.aws.neptune.model.RestoreDbClusterFromSnapshotResponse
      .wrap(buildAwsValue())
}
object RestoreDbClusterFromSnapshotResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.neptune.model.RestoreDbClusterFromSnapshotResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.neptune.model.RestoreDbClusterFromSnapshotResponse =
      zio.aws.neptune.model.RestoreDbClusterFromSnapshotResponse(
        dbCluster.map(value => value.asEditable)
      )
    def dbCluster: Optional[zio.aws.neptune.model.DBCluster.ReadOnly]
    def getDbCluster
        : ZIO[Any, AwsError, zio.aws.neptune.model.DBCluster.ReadOnly] =
      AwsError.unwrapOptionField("dbCluster", dbCluster)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.neptune.model.RestoreDbClusterFromSnapshotResponse
  ) extends zio.aws.neptune.model.RestoreDbClusterFromSnapshotResponse.ReadOnly {
    override val dbCluster: Optional[zio.aws.neptune.model.DBCluster.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbCluster())
        .map(value => zio.aws.neptune.model.DBCluster.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.neptune.model.RestoreDbClusterFromSnapshotResponse
  ): zio.aws.neptune.model.RestoreDbClusterFromSnapshotResponse.ReadOnly =
    new Wrapper(impl)
}
