package zio.aws.neptune.model
import zio.aws.neptune.model.primitives.{
  BooleanOptional,
  IntegerOptional,
  TStamp
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class RestoreDbClusterToPointInTimeRequest(
    dbClusterIdentifier: String,
    restoreType: Optional[String] = Optional.Absent,
    sourceDBClusterIdentifier: String,
    restoreToTime: Optional[TStamp] = Optional.Absent,
    useLatestRestorableTime: Optional[Boolean] = Optional.Absent,
    port: Optional[IntegerOptional] = Optional.Absent,
    dbSubnetGroupName: Optional[String] = Optional.Absent,
    optionGroupName: Optional[String] = Optional.Absent,
    vpcSecurityGroupIds: Optional[Iterable[String]] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.neptune.model.Tag]] = Optional.Absent,
    kmsKeyId: Optional[String] = Optional.Absent,
    enableIAMDatabaseAuthentication: Optional[BooleanOptional] =
      Optional.Absent,
    enableCloudwatchLogsExports: Optional[Iterable[String]] = Optional.Absent,
    dbClusterParameterGroupName: Optional[String] = Optional.Absent,
    deletionProtection: Optional[BooleanOptional] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.neptune.model.RestoreDbClusterToPointInTimeRequest = {
    import RestoreDbClusterToPointInTimeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.neptune.model.RestoreDbClusterToPointInTimeRequest
      .builder()
      .dbClusterIdentifier(dbClusterIdentifier: java.lang.String)
      .optionallyWith(restoreType.map(value => value: java.lang.String))(
        _.restoreType
      )
      .sourceDBClusterIdentifier(sourceDBClusterIdentifier: java.lang.String)
      .optionallyWith(
        restoreToTime.map(value => TStamp.unwrap(value): Instant)
      )(_.restoreToTime)
      .optionallyWith(
        useLatestRestorableTime.map(value => value: java.lang.Boolean)
      )(_.useLatestRestorableTime)
      .optionallyWith(port.map(value => value: Integer))(_.port)
      .optionallyWith(dbSubnetGroupName.map(value => value: java.lang.String))(
        _.dbSubnetGroupName
      )
      .optionallyWith(optionGroupName.map(value => value: java.lang.String))(
        _.optionGroupName
      )
      .optionallyWith(
        vpcSecurityGroupIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.vpcSecurityGroupIds)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(
        enableIAMDatabaseAuthentication.map(value => value: java.lang.Boolean)
      )(_.enableIAMDatabaseAuthentication)
      .optionallyWith(
        enableCloudwatchLogsExports.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.enableCloudwatchLogsExports)
      .optionallyWith(
        dbClusterParameterGroupName.map(value => value: java.lang.String)
      )(_.dbClusterParameterGroupName)
      .optionallyWith(
        deletionProtection.map(value => value: java.lang.Boolean)
      )(_.deletionProtection)
      .build()
  }
  def asReadOnly
      : zio.aws.neptune.model.RestoreDbClusterToPointInTimeRequest.ReadOnly =
    zio.aws.neptune.model.RestoreDbClusterToPointInTimeRequest
      .wrap(buildAwsValue())
}
object RestoreDbClusterToPointInTimeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.neptune.model.RestoreDbClusterToPointInTimeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.neptune.model.RestoreDbClusterToPointInTimeRequest =
      zio.aws.neptune.model.RestoreDbClusterToPointInTimeRequest(
        dbClusterIdentifier,
        restoreType.map(value => value),
        sourceDBClusterIdentifier,
        restoreToTime.map(value => value),
        useLatestRestorableTime.map(value => value),
        port.map(value => value),
        dbSubnetGroupName.map(value => value),
        optionGroupName.map(value => value),
        vpcSecurityGroupIds.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        kmsKeyId.map(value => value),
        enableIAMDatabaseAuthentication.map(value => value),
        enableCloudwatchLogsExports.map(value => value),
        dbClusterParameterGroupName.map(value => value),
        deletionProtection.map(value => value)
      )
    def dbClusterIdentifier: String
    def restoreType: Optional[String]
    def sourceDBClusterIdentifier: String
    def restoreToTime: Optional[TStamp]
    def useLatestRestorableTime: Optional[Boolean]
    def port: Optional[IntegerOptional]
    def dbSubnetGroupName: Optional[String]
    def optionGroupName: Optional[String]
    def vpcSecurityGroupIds: Optional[List[String]]
    def tags: Optional[List[zio.aws.neptune.model.Tag.ReadOnly]]
    def kmsKeyId: Optional[String]
    def enableIAMDatabaseAuthentication: Optional[BooleanOptional]
    def enableCloudwatchLogsExports: Optional[List[String]]
    def dbClusterParameterGroupName: Optional[String]
    def deletionProtection: Optional[BooleanOptional]
    def getDbClusterIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbClusterIdentifier)
    def getRestoreType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("restoreType", restoreType)
    def getSourceDBClusterIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(sourceDBClusterIdentifier)
    def getRestoreToTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("restoreToTime", restoreToTime)
    def getUseLatestRestorableTime: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("useLatestRestorableTime", useLatestRestorableTime)
    def getPort: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("port", port)
    def getDbSubnetGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbSubnetGroupName", dbSubnetGroupName)
    def getOptionGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("optionGroupName", optionGroupName)
    def getVpcSecurityGroupIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("vpcSecurityGroupIds", vpcSecurityGroupIds)
    def getTags: ZIO[Any, AwsError, List[zio.aws.neptune.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getEnableIAMDatabaseAuthentication
        : ZIO[Any, AwsError, BooleanOptional] = AwsError.unwrapOptionField(
      "enableIAMDatabaseAuthentication",
      enableIAMDatabaseAuthentication
    )
    def getEnableCloudwatchLogsExports: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField(
        "enableCloudwatchLogsExports",
        enableCloudwatchLogsExports
      )
    def getDbClusterParameterGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "dbClusterParameterGroupName",
        dbClusterParameterGroupName
      )
    def getDeletionProtection: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("deletionProtection", deletionProtection)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.neptune.model.RestoreDbClusterToPointInTimeRequest
  ) extends zio.aws.neptune.model.RestoreDbClusterToPointInTimeRequest.ReadOnly {
    override val dbClusterIdentifier: String =
      impl.dbClusterIdentifier(): String
    override val restoreType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.restoreType())
      .map(value => value: String)
    override val sourceDBClusterIdentifier: String =
      impl.sourceDBClusterIdentifier(): String
    override val restoreToTime: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.restoreToTime())
      .map(value => zio.aws.neptune.model.primitives.TStamp(value))
    override val useLatestRestorableTime: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.useLatestRestorableTime())
        .map(value => value: Boolean)
    override val port: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.port())
      .map(value => value: IntegerOptional)
    override val dbSubnetGroupName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbSubnetGroupName())
      .map(value => value: String)
    override val optionGroupName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.optionGroupName())
      .map(value => value: String)
    override val vpcSecurityGroupIds: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcSecurityGroupIds())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val tags: Optional[List[zio.aws.neptune.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.neptune.model.Tag.wrap(item)
          }.toList
        )
    override val kmsKeyId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => value: String)
    override val enableIAMDatabaseAuthentication: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableIAMDatabaseAuthentication())
        .map(value => value: BooleanOptional)
    override val enableCloudwatchLogsExports: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableCloudwatchLogsExports())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val dbClusterParameterGroupName: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbClusterParameterGroupName())
        .map(value => value: String)
    override val deletionProtection: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deletionProtection())
        .map(value => value: BooleanOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.neptune.model.RestoreDbClusterToPointInTimeRequest
  ): zio.aws.neptune.model.RestoreDbClusterToPointInTimeRequest.ReadOnly =
    new Wrapper(impl)
}
