package zio.aws.neptune.model
import scala.jdk.CollectionConverters._
sealed trait SourceType {
  def unwrap: software.amazon.awssdk.services.neptune.model.SourceType
}
object SourceType {
  def wrap(
      value: software.amazon.awssdk.services.neptune.model.SourceType
  ): zio.aws.neptune.model.SourceType = value match {
    case software.amazon.awssdk.services.neptune.model.SourceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.neptune.model.SourceType.DB_INSTANCE =>
      val r = `db-instance`
      r
    case software.amazon.awssdk.services.neptune.model.SourceType.DB_PARAMETER_GROUP =>
      val r = `db-parameter-group`
      r
    case software.amazon.awssdk.services.neptune.model.SourceType.DB_SECURITY_GROUP =>
      val r = `db-security-group`
      r
    case software.amazon.awssdk.services.neptune.model.SourceType.DB_SNAPSHOT =>
      val r = `db-snapshot`
      r
    case software.amazon.awssdk.services.neptune.model.SourceType.DB_CLUSTER =>
      val r = `db-cluster`
      r
    case software.amazon.awssdk.services.neptune.model.SourceType.DB_CLUSTER_SNAPSHOT =>
      val r = `db-cluster-snapshot`
      r
  }
  case object unknownToSdkVersion extends zio.aws.neptune.model.SourceType {
    override def unwrap
        : software.amazon.awssdk.services.neptune.model.SourceType =
      software.amazon.awssdk.services.neptune.model.SourceType.UNKNOWN_TO_SDK_VERSION
  }
  case object `db-instance` extends zio.aws.neptune.model.SourceType {
    override def unwrap
        : software.amazon.awssdk.services.neptune.model.SourceType =
      software.amazon.awssdk.services.neptune.model.SourceType.DB_INSTANCE
  }
  case object `db-parameter-group` extends zio.aws.neptune.model.SourceType {
    override def unwrap
        : software.amazon.awssdk.services.neptune.model.SourceType =
      software.amazon.awssdk.services.neptune.model.SourceType.DB_PARAMETER_GROUP
  }
  case object `db-security-group` extends zio.aws.neptune.model.SourceType {
    override def unwrap
        : software.amazon.awssdk.services.neptune.model.SourceType =
      software.amazon.awssdk.services.neptune.model.SourceType.DB_SECURITY_GROUP
  }
  case object `db-snapshot` extends zio.aws.neptune.model.SourceType {
    override def unwrap
        : software.amazon.awssdk.services.neptune.model.SourceType =
      software.amazon.awssdk.services.neptune.model.SourceType.DB_SNAPSHOT
  }
  case object `db-cluster` extends zio.aws.neptune.model.SourceType {
    override def unwrap
        : software.amazon.awssdk.services.neptune.model.SourceType =
      software.amazon.awssdk.services.neptune.model.SourceType.DB_CLUSTER
  }
  case object `db-cluster-snapshot` extends zio.aws.neptune.model.SourceType {
    override def unwrap
        : software.amazon.awssdk.services.neptune.model.SourceType =
      software.amazon.awssdk.services.neptune.model.SourceType.DB_CLUSTER_SNAPSHOT
  }
}
