package zio.aws.neptune.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Timezone(timezoneName: Optional[String] = Optional.Absent) {
  def buildAwsValue()
      : software.amazon.awssdk.services.neptune.model.Timezone = {
    import Timezone.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.neptune.model.Timezone
      .builder()
      .optionallyWith(timezoneName.map(value => value: java.lang.String))(
        _.timezoneName
      )
      .build()
  }
  def asReadOnly: zio.aws.neptune.model.Timezone.ReadOnly =
    zio.aws.neptune.model.Timezone.wrap(buildAwsValue())
}
object Timezone {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.neptune.model.Timezone] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.neptune.model.Timezone =
      zio.aws.neptune.model.Timezone(timezoneName.map(value => value))
    def timezoneName: Optional[String]
    def getTimezoneName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("timezoneName", timezoneName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.neptune.model.Timezone
  ) extends zio.aws.neptune.model.Timezone.ReadOnly {
    override val timezoneName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.timezoneName())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.neptune.model.Timezone
  ): zio.aws.neptune.model.Timezone.ReadOnly = new Wrapper(impl)
}
