package zio.aws.nimble.model
import zio.aws.nimble.model.primitives.{
  ActiveDirectoryComputerAttributeValue,
  ActiveDirectoryComputerAttributeName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ActiveDirectoryComputerAttribute(
    name: Optional[ActiveDirectoryComputerAttributeName] = Optional.Absent,
    value: Optional[ActiveDirectoryComputerAttributeValue] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.ActiveDirectoryComputerAttribute = {
    import ActiveDirectoryComputerAttribute.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.ActiveDirectoryComputerAttribute
      .builder()
      .optionallyWith(
        name.map(value =>
          ActiveDirectoryComputerAttributeName.unwrap(value): java.lang.String
        )
      )(_.name)
      .optionallyWith(
        value.map(value =>
          ActiveDirectoryComputerAttributeValue.unwrap(value): java.lang.String
        )
      )(_.value)
      .build()
  }
  def asReadOnly
      : zio.aws.nimble.model.ActiveDirectoryComputerAttribute.ReadOnly =
    zio.aws.nimble.model.ActiveDirectoryComputerAttribute.wrap(buildAwsValue())
}
object ActiveDirectoryComputerAttribute {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.ActiveDirectoryComputerAttribute
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.ActiveDirectoryComputerAttribute =
      zio.aws.nimble.model.ActiveDirectoryComputerAttribute(
        name.map(value => value),
        value.map(value => value)
      )
    def name: Optional[ActiveDirectoryComputerAttributeName]
    def value: Optional[ActiveDirectoryComputerAttributeValue]
    def getName: ZIO[Any, AwsError, ActiveDirectoryComputerAttributeName] =
      AwsError.unwrapOptionField("name", name)
    def getValue: ZIO[Any, AwsError, ActiveDirectoryComputerAttributeValue] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.ActiveDirectoryComputerAttribute
  ) extends zio.aws.nimble.model.ActiveDirectoryComputerAttribute.ReadOnly {
    override val name: Optional[ActiveDirectoryComputerAttributeName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.name())
        .map(value =>
          zio.aws.nimble.model.primitives
            .ActiveDirectoryComputerAttributeName(value)
        )
    override val value: Optional[ActiveDirectoryComputerAttributeValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.value())
        .map(value =>
          zio.aws.nimble.model.primitives
            .ActiveDirectoryComputerAttributeValue(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.ActiveDirectoryComputerAttribute
  ): zio.aws.nimble.model.ActiveDirectoryComputerAttribute.ReadOnly =
    new Wrapper(impl)
}
