package zio.aws.nimble.model
import zio.aws.nimble.model.primitives.{
  RoleArn,
  SecurityGroupId,
  StudioComponentDescription,
  StudioComponentName,
  ClientToken
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateStudioComponentRequest(
    clientToken: Optional[ClientToken] = Optional.Absent,
    configuration: Optional[zio.aws.nimble.model.StudioComponentConfiguration] =
      Optional.Absent,
    description: Optional[StudioComponentDescription] = Optional.Absent,
    ec2SecurityGroupIds: Optional[Iterable[SecurityGroupId]] = Optional.Absent,
    initializationScripts: Optional[
      Iterable[zio.aws.nimble.model.StudioComponentInitializationScript]
    ] = Optional.Absent,
    name: StudioComponentName,
    runtimeRoleArn: Optional[RoleArn] = Optional.Absent,
    scriptParameters: Optional[
      Iterable[zio.aws.nimble.model.ScriptParameterKeyValue]
    ] = Optional.Absent,
    secureInitializationRoleArn: Optional[RoleArn] = Optional.Absent,
    studioId: String,
    subtype: Optional[zio.aws.nimble.model.StudioComponentSubtype] =
      Optional.Absent,
    tags: Optional[Map[String, String]] = Optional.Absent,
    `type`: zio.aws.nimble.model.StudioComponentType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.CreateStudioComponentRequest = {
    import CreateStudioComponentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.CreateStudioComponentRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(configuration.map(value => value.buildAwsValue()))(
        _.configuration
      )
      .optionallyWith(
        description.map(value =>
          StudioComponentDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        ec2SecurityGroupIds.map(value =>
          value.map { item =>
            SecurityGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.ec2SecurityGroupIds)
      .optionallyWith(
        initializationScripts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.initializationScripts)
      .name(StudioComponentName.unwrap(name): java.lang.String)
      .optionallyWith(
        runtimeRoleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.runtimeRoleArn)
      .optionallyWith(
        scriptParameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.scriptParameters)
      .optionallyWith(
        secureInitializationRoleArn.map(value =>
          RoleArn.unwrap(value): java.lang.String
        )
      )(_.secureInitializationRoleArn)
      .studioId(studioId: java.lang.String)
      .optionallyWith(subtype.map(value => value.unwrap))(_.subtype)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .`type`(`type`.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.CreateStudioComponentRequest.ReadOnly =
    zio.aws.nimble.model.CreateStudioComponentRequest.wrap(buildAwsValue())
}
object CreateStudioComponentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.CreateStudioComponentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.CreateStudioComponentRequest =
      zio.aws.nimble.model.CreateStudioComponentRequest(
        clientToken.map(value => value),
        configuration.map(value => value.asEditable),
        description.map(value => value),
        ec2SecurityGroupIds.map(value => value),
        initializationScripts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        name,
        runtimeRoleArn.map(value => value),
        scriptParameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        secureInitializationRoleArn.map(value => value),
        studioId,
        subtype.map(value => value),
        tags.map(value => value),
        `type`
      )
    def clientToken: Optional[ClientToken]
    def configuration
        : Optional[zio.aws.nimble.model.StudioComponentConfiguration.ReadOnly]
    def description: Optional[StudioComponentDescription]
    def ec2SecurityGroupIds: Optional[List[SecurityGroupId]]
    def initializationScripts: Optional[
      List[zio.aws.nimble.model.StudioComponentInitializationScript.ReadOnly]
    ]
    def name: StudioComponentName
    def runtimeRoleArn: Optional[RoleArn]
    def scriptParameters
        : Optional[List[zio.aws.nimble.model.ScriptParameterKeyValue.ReadOnly]]
    def secureInitializationRoleArn: Optional[RoleArn]
    def studioId: String
    def subtype: Optional[zio.aws.nimble.model.StudioComponentSubtype]
    def tags: Optional[Map[String, String]]
    def `type`: zio.aws.nimble.model.StudioComponentType
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.nimble.model.StudioComponentConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("configuration", configuration)
    def getDescription: ZIO[Any, AwsError, StudioComponentDescription] =
      AwsError.unwrapOptionField("description", description)
    def getEc2SecurityGroupIds: ZIO[Any, AwsError, List[SecurityGroupId]] =
      AwsError.unwrapOptionField("ec2SecurityGroupIds", ec2SecurityGroupIds)
    def getInitializationScripts: ZIO[Any, AwsError, List[
      zio.aws.nimble.model.StudioComponentInitializationScript.ReadOnly
    ]] =
      AwsError.unwrapOptionField("initializationScripts", initializationScripts)
    def getName: ZIO[Any, Nothing, StudioComponentName] = ZIO.succeed(name)
    def getRuntimeRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("runtimeRoleArn", runtimeRoleArn)
    def getScriptParameters: ZIO[Any, AwsError, List[
      zio.aws.nimble.model.ScriptParameterKeyValue.ReadOnly
    ]] = AwsError.unwrapOptionField("scriptParameters", scriptParameters)
    def getSecureInitializationRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField(
        "secureInitializationRoleArn",
        secureInitializationRoleArn
      )
    def getStudioId: ZIO[Any, Nothing, String] = ZIO.succeed(studioId)
    def getSubtype
        : ZIO[Any, AwsError, zio.aws.nimble.model.StudioComponentSubtype] =
      AwsError.unwrapOptionField("subtype", subtype)
    def getTags: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("tags", tags)
    def getType: ZIO[Any, Nothing, zio.aws.nimble.model.StudioComponentType] =
      ZIO.succeed(`type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.CreateStudioComponentRequest
  ) extends zio.aws.nimble.model.CreateStudioComponentRequest.ReadOnly {
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.nimble.model.primitives.ClientToken(value))
    override val configuration
        : Optional[zio.aws.nimble.model.StudioComponentConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.configuration())
        .map(value =>
          zio.aws.nimble.model.StudioComponentConfiguration.wrap(value)
        )
    override val description: Optional[StudioComponentDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.nimble.model.primitives.StudioComponentDescription(value)
        )
    override val ec2SecurityGroupIds: Optional[List[SecurityGroupId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ec2SecurityGroupIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.nimble.model.primitives.SecurityGroupId(item)
          }.toList
        )
    override val initializationScripts: Optional[
      List[zio.aws.nimble.model.StudioComponentInitializationScript.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.initializationScripts())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.nimble.model.StudioComponentInitializationScript.wrap(item)
        }.toList
      )
    override val name: StudioComponentName =
      zio.aws.nimble.model.primitives.StudioComponentName(impl.name())
    override val runtimeRoleArn: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.runtimeRoleArn())
      .map(value => zio.aws.nimble.model.primitives.RoleArn(value))
    override val scriptParameters: Optional[
      List[zio.aws.nimble.model.ScriptParameterKeyValue.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.scriptParameters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.nimble.model.ScriptParameterKeyValue.wrap(item)
        }.toList
      )
    override val secureInitializationRoleArn: Optional[RoleArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.secureInitializationRoleArn())
        .map(value => zio.aws.nimble.model.primitives.RoleArn(value))
    override val studioId: String = impl.studioId(): String
    override val subtype
        : Optional[zio.aws.nimble.model.StudioComponentSubtype] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subtype())
        .map(value => zio.aws.nimble.model.StudioComponentSubtype.wrap(value))
    override val tags: Optional[Map[String, String]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override val `type`: zio.aws.nimble.model.StudioComponentType =
      zio.aws.nimble.model.StudioComponentType.wrap(impl.`type`())
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.CreateStudioComponentRequest
  ): zio.aws.nimble.model.CreateStudioComponentRequest.ReadOnly = new Wrapper(
    impl
  )
}
