package zio.aws.nimble.model
import zio.aws.nimble.model.primitives.{
  StudioName,
  StudioDisplayName,
  ClientToken,
  RoleArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateStudioRequest(
    adminRoleArn: RoleArn,
    clientToken: Optional[ClientToken] = Optional.Absent,
    displayName: StudioDisplayName,
    studioEncryptionConfiguration: Optional[
      zio.aws.nimble.model.StudioEncryptionConfiguration
    ] = Optional.Absent,
    studioName: StudioName,
    tags: Optional[Map[String, String]] = Optional.Absent,
    userRoleArn: RoleArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.CreateStudioRequest = {
    import CreateStudioRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.CreateStudioRequest
      .builder()
      .adminRoleArn(RoleArn.unwrap(adminRoleArn): java.lang.String)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .displayName(StudioDisplayName.unwrap(displayName): java.lang.String)
      .optionallyWith(
        studioEncryptionConfiguration.map(value => value.buildAwsValue())
      )(_.studioEncryptionConfiguration)
      .studioName(StudioName.unwrap(studioName): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .userRoleArn(RoleArn.unwrap(userRoleArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.CreateStudioRequest.ReadOnly =
    zio.aws.nimble.model.CreateStudioRequest.wrap(buildAwsValue())
}
object CreateStudioRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.CreateStudioRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.CreateStudioRequest =
      zio.aws.nimble.model.CreateStudioRequest(
        adminRoleArn,
        clientToken.map(value => value),
        displayName,
        studioEncryptionConfiguration.map(value => value.asEditable),
        studioName,
        tags.map(value => value),
        userRoleArn
      )
    def adminRoleArn: RoleArn
    def clientToken: Optional[ClientToken]
    def displayName: StudioDisplayName
    def studioEncryptionConfiguration
        : Optional[zio.aws.nimble.model.StudioEncryptionConfiguration.ReadOnly]
    def studioName: StudioName
    def tags: Optional[Map[String, String]]
    def userRoleArn: RoleArn
    def getAdminRoleArn: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(adminRoleArn)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getDisplayName: ZIO[Any, Nothing, StudioDisplayName] =
      ZIO.succeed(displayName)
    def getStudioEncryptionConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.nimble.model.StudioEncryptionConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "studioEncryptionConfiguration",
      studioEncryptionConfiguration
    )
    def getStudioName: ZIO[Any, Nothing, StudioName] = ZIO.succeed(studioName)
    def getTags: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("tags", tags)
    def getUserRoleArn: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(userRoleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.CreateStudioRequest
  ) extends zio.aws.nimble.model.CreateStudioRequest.ReadOnly {
    override val adminRoleArn: RoleArn =
      zio.aws.nimble.model.primitives.RoleArn(impl.adminRoleArn())
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.nimble.model.primitives.ClientToken(value))
    override val displayName: StudioDisplayName =
      zio.aws.nimble.model.primitives.StudioDisplayName(impl.displayName())
    override val studioEncryptionConfiguration: Optional[
      zio.aws.nimble.model.StudioEncryptionConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.studioEncryptionConfiguration())
      .map(value =>
        zio.aws.nimble.model.StudioEncryptionConfiguration.wrap(value)
      )
    override val studioName: StudioName =
      zio.aws.nimble.model.primitives.StudioName(impl.studioName())
    override val tags: Optional[Map[String, String]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override val userRoleArn: RoleArn =
      zio.aws.nimble.model.primitives.RoleArn(impl.userRoleArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.CreateStudioRequest
  ): zio.aws.nimble.model.CreateStudioRequest.ReadOnly = new Wrapper(impl)
}
