package zio.aws.nimble.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateStudioResponse(
    studio: Optional[zio.aws.nimble.model.Studio] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.CreateStudioResponse = {
    import CreateStudioResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.CreateStudioResponse
      .builder()
      .optionallyWith(studio.map(value => value.buildAwsValue()))(_.studio)
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.CreateStudioResponse.ReadOnly =
    zio.aws.nimble.model.CreateStudioResponse.wrap(buildAwsValue())
}
object CreateStudioResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.CreateStudioResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.CreateStudioResponse =
      zio.aws.nimble.model
        .CreateStudioResponse(studio.map(value => value.asEditable))
    def studio: Optional[zio.aws.nimble.model.Studio.ReadOnly]
    def getStudio: ZIO[Any, AwsError, zio.aws.nimble.model.Studio.ReadOnly] =
      AwsError.unwrapOptionField("studio", studio)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.CreateStudioResponse
  ) extends zio.aws.nimble.model.CreateStudioResponse.ReadOnly {
    override val studio: Optional[zio.aws.nimble.model.Studio.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.studio())
        .map(value => zio.aws.nimble.model.Studio.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.CreateStudioResponse
  ): zio.aws.nimble.model.CreateStudioResponse.ReadOnly = new Wrapper(impl)
}
