package zio.aws.nimble.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetLaunchProfileDetailsRequest(
    launchProfileId: String,
    studioId: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.GetLaunchProfileDetailsRequest = {
    import GetLaunchProfileDetailsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.GetLaunchProfileDetailsRequest
      .builder()
      .launchProfileId(launchProfileId: java.lang.String)
      .studioId(studioId: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.GetLaunchProfileDetailsRequest.ReadOnly =
    zio.aws.nimble.model.GetLaunchProfileDetailsRequest.wrap(buildAwsValue())
}
object GetLaunchProfileDetailsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.GetLaunchProfileDetailsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.GetLaunchProfileDetailsRequest =
      zio.aws.nimble.model
        .GetLaunchProfileDetailsRequest(launchProfileId, studioId)
    def launchProfileId: String
    def studioId: String
    def getLaunchProfileId: ZIO[Any, Nothing, String] =
      ZIO.succeed(launchProfileId)
    def getStudioId: ZIO[Any, Nothing, String] = ZIO.succeed(studioId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.GetLaunchProfileDetailsRequest
  ) extends zio.aws.nimble.model.GetLaunchProfileDetailsRequest.ReadOnly {
    override val launchProfileId: String = impl.launchProfileId(): String
    override val studioId: String = impl.studioId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.GetLaunchProfileDetailsRequest
  ): zio.aws.nimble.model.GetLaunchProfileDetailsRequest.ReadOnly = new Wrapper(
    impl
  )
}
