package zio.aws.nimble.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetLaunchProfileMemberRequest(
    launchProfileId: String,
    principalId: String,
    studioId: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.GetLaunchProfileMemberRequest = {
    import GetLaunchProfileMemberRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.GetLaunchProfileMemberRequest
      .builder()
      .launchProfileId(launchProfileId: java.lang.String)
      .principalId(principalId: java.lang.String)
      .studioId(studioId: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.GetLaunchProfileMemberRequest.ReadOnly =
    zio.aws.nimble.model.GetLaunchProfileMemberRequest.wrap(buildAwsValue())
}
object GetLaunchProfileMemberRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.GetLaunchProfileMemberRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.GetLaunchProfileMemberRequest =
      zio.aws.nimble.model
        .GetLaunchProfileMemberRequest(launchProfileId, principalId, studioId)
    def launchProfileId: String
    def principalId: String
    def studioId: String
    def getLaunchProfileId: ZIO[Any, Nothing, String] =
      ZIO.succeed(launchProfileId)
    def getPrincipalId: ZIO[Any, Nothing, String] = ZIO.succeed(principalId)
    def getStudioId: ZIO[Any, Nothing, String] = ZIO.succeed(studioId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.GetLaunchProfileMemberRequest
  ) extends zio.aws.nimble.model.GetLaunchProfileMemberRequest.ReadOnly {
    override val launchProfileId: String = impl.launchProfileId(): String
    override val principalId: String = impl.principalId(): String
    override val studioId: String = impl.studioId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.GetLaunchProfileMemberRequest
  ): zio.aws.nimble.model.GetLaunchProfileMemberRequest.ReadOnly = new Wrapper(
    impl
  )
}
