package zio.aws.nimble.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetStreamingImageRequest(
    streamingImageId: String,
    studioId: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.GetStreamingImageRequest = {
    import GetStreamingImageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.GetStreamingImageRequest
      .builder()
      .streamingImageId(streamingImageId: java.lang.String)
      .studioId(studioId: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.GetStreamingImageRequest.ReadOnly =
    zio.aws.nimble.model.GetStreamingImageRequest.wrap(buildAwsValue())
}
object GetStreamingImageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.GetStreamingImageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.GetStreamingImageRequest =
      zio.aws.nimble.model.GetStreamingImageRequest(streamingImageId, studioId)
    def streamingImageId: String
    def studioId: String
    def getStreamingImageId: ZIO[Any, Nothing, String] =
      ZIO.succeed(streamingImageId)
    def getStudioId: ZIO[Any, Nothing, String] = ZIO.succeed(studioId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.GetStreamingImageRequest
  ) extends zio.aws.nimble.model.GetStreamingImageRequest.ReadOnly {
    override val streamingImageId: String = impl.streamingImageId(): String
    override val studioId: String = impl.studioId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.GetStreamingImageRequest
  ): zio.aws.nimble.model.GetStreamingImageRequest.ReadOnly = new Wrapper(impl)
}
