package zio.aws.nimble.model
import scala.jdk.CollectionConverters._
sealed trait LaunchProfileState {
  def unwrap: software.amazon.awssdk.services.nimble.model.LaunchProfileState
}
object LaunchProfileState {
  def wrap(
      value: software.amazon.awssdk.services.nimble.model.LaunchProfileState
  ): zio.aws.nimble.model.LaunchProfileState = value match {
    case software.amazon.awssdk.services.nimble.model.LaunchProfileState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.nimble.model.LaunchProfileState.CREATE_IN_PROGRESS =>
      val r = CREATE_IN_PROGRESS
      r
    case software.amazon.awssdk.services.nimble.model.LaunchProfileState.READY =>
      val r = READY
      r
    case software.amazon.awssdk.services.nimble.model.LaunchProfileState.UPDATE_IN_PROGRESS =>
      val r = UPDATE_IN_PROGRESS
      r
    case software.amazon.awssdk.services.nimble.model.LaunchProfileState.DELETE_IN_PROGRESS =>
      val r = DELETE_IN_PROGRESS
      r
    case software.amazon.awssdk.services.nimble.model.LaunchProfileState.DELETED =>
      val r = DELETED
      r
    case software.amazon.awssdk.services.nimble.model.LaunchProfileState.DELETE_FAILED =>
      val r = DELETE_FAILED
      r
    case software.amazon.awssdk.services.nimble.model.LaunchProfileState.CREATE_FAILED =>
      val r = CREATE_FAILED
      r
    case software.amazon.awssdk.services.nimble.model.LaunchProfileState.UPDATE_FAILED =>
      val r = UPDATE_FAILED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.nimble.model.LaunchProfileState {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.LaunchProfileState =
      software.amazon.awssdk.services.nimble.model.LaunchProfileState.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATE_IN_PROGRESS
      extends zio.aws.nimble.model.LaunchProfileState {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.LaunchProfileState =
      software.amazon.awssdk.services.nimble.model.LaunchProfileState.CREATE_IN_PROGRESS
  }
  case object READY extends zio.aws.nimble.model.LaunchProfileState {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.LaunchProfileState =
      software.amazon.awssdk.services.nimble.model.LaunchProfileState.READY
  }
  case object UPDATE_IN_PROGRESS
      extends zio.aws.nimble.model.LaunchProfileState {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.LaunchProfileState =
      software.amazon.awssdk.services.nimble.model.LaunchProfileState.UPDATE_IN_PROGRESS
  }
  case object DELETE_IN_PROGRESS
      extends zio.aws.nimble.model.LaunchProfileState {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.LaunchProfileState =
      software.amazon.awssdk.services.nimble.model.LaunchProfileState.DELETE_IN_PROGRESS
  }
  case object DELETED extends zio.aws.nimble.model.LaunchProfileState {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.LaunchProfileState =
      software.amazon.awssdk.services.nimble.model.LaunchProfileState.DELETED
  }
  case object DELETE_FAILED extends zio.aws.nimble.model.LaunchProfileState {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.LaunchProfileState =
      software.amazon.awssdk.services.nimble.model.LaunchProfileState.DELETE_FAILED
  }
  case object CREATE_FAILED extends zio.aws.nimble.model.LaunchProfileState {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.LaunchProfileState =
      software.amazon.awssdk.services.nimble.model.LaunchProfileState.CREATE_FAILED
  }
  case object UPDATE_FAILED extends zio.aws.nimble.model.LaunchProfileState {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.LaunchProfileState =
      software.amazon.awssdk.services.nimble.model.LaunchProfileState.UPDATE_FAILED
  }
}
