package zio.aws.nimble.model
import scala.jdk.CollectionConverters._
sealed trait LaunchProfileValidationType {
  def unwrap
      : software.amazon.awssdk.services.nimble.model.LaunchProfileValidationType
}
object LaunchProfileValidationType {
  def wrap(
      value: software.amazon.awssdk.services.nimble.model.LaunchProfileValidationType
  ): zio.aws.nimble.model.LaunchProfileValidationType = value match {
    case software.amazon.awssdk.services.nimble.model.LaunchProfileValidationType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.nimble.model.LaunchProfileValidationType.VALIDATE_ACTIVE_DIRECTORY_STUDIO_COMPONENT =>
      val r = VALIDATE_ACTIVE_DIRECTORY_STUDIO_COMPONENT
      r
    case software.amazon.awssdk.services.nimble.model.LaunchProfileValidationType.VALIDATE_SUBNET_ASSOCIATION =>
      val r = VALIDATE_SUBNET_ASSOCIATION
      r
    case software.amazon.awssdk.services.nimble.model.LaunchProfileValidationType.VALIDATE_NETWORK_ACL_ASSOCIATION =>
      val r = VALIDATE_NETWORK_ACL_ASSOCIATION
      r
    case software.amazon.awssdk.services.nimble.model.LaunchProfileValidationType.VALIDATE_SECURITY_GROUP_ASSOCIATION =>
      val r = VALIDATE_SECURITY_GROUP_ASSOCIATION
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.nimble.model.LaunchProfileValidationType {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.LaunchProfileValidationType =
      software.amazon.awssdk.services.nimble.model.LaunchProfileValidationType.UNKNOWN_TO_SDK_VERSION
  }
  case object VALIDATE_ACTIVE_DIRECTORY_STUDIO_COMPONENT
      extends zio.aws.nimble.model.LaunchProfileValidationType {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.LaunchProfileValidationType =
      software.amazon.awssdk.services.nimble.model.LaunchProfileValidationType.VALIDATE_ACTIVE_DIRECTORY_STUDIO_COMPONENT
  }
  case object VALIDATE_SUBNET_ASSOCIATION
      extends zio.aws.nimble.model.LaunchProfileValidationType {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.LaunchProfileValidationType =
      software.amazon.awssdk.services.nimble.model.LaunchProfileValidationType.VALIDATE_SUBNET_ASSOCIATION
  }
  case object VALIDATE_NETWORK_ACL_ASSOCIATION
      extends zio.aws.nimble.model.LaunchProfileValidationType {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.LaunchProfileValidationType =
      software.amazon.awssdk.services.nimble.model.LaunchProfileValidationType.VALIDATE_NETWORK_ACL_ASSOCIATION
  }
  case object VALIDATE_SECURITY_GROUP_ASSOCIATION
      extends zio.aws.nimble.model.LaunchProfileValidationType {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.LaunchProfileValidationType =
      software.amazon.awssdk.services.nimble.model.LaunchProfileValidationType.VALIDATE_SECURITY_GROUP_ASSOCIATION
  }
}
