package zio.aws.nimble.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.nimble.model.primitives.MaxResults
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListStudioComponentsRequest(
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent,
    states: Optional[Iterable[zio.aws.nimble.model.StudioComponentState]] =
      Optional.Absent,
    studioId: String,
    types: Optional[Iterable[zio.aws.nimble.model.StudioComponentType]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.ListStudioComponentsRequest = {
    import ListStudioComponentsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.ListStudioComponentsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        states.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.statesWithStrings)
      .studioId(studioId: java.lang.String)
      .optionallyWith(
        types.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.typesWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.ListStudioComponentsRequest.ReadOnly =
    zio.aws.nimble.model.ListStudioComponentsRequest.wrap(buildAwsValue())
}
object ListStudioComponentsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.ListStudioComponentsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.ListStudioComponentsRequest =
      zio.aws.nimble.model.ListStudioComponentsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        states.map(value => value),
        studioId,
        types.map(value => value)
      )
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[String]
    def states: Optional[List[zio.aws.nimble.model.StudioComponentState]]
    def studioId: String
    def types: Optional[List[zio.aws.nimble.model.StudioComponentType]]
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getStates
        : ZIO[Any, AwsError, List[zio.aws.nimble.model.StudioComponentState]] =
      AwsError.unwrapOptionField("states", states)
    def getStudioId: ZIO[Any, Nothing, String] = ZIO.succeed(studioId)
    def getTypes
        : ZIO[Any, AwsError, List[zio.aws.nimble.model.StudioComponentType]] =
      AwsError.unwrapOptionField("types", types)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.ListStudioComponentsRequest
  ) extends zio.aws.nimble.model.ListStudioComponentsRequest.ReadOnly {
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.nimble.model.primitives.MaxResults(value))
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val states
        : Optional[List[zio.aws.nimble.model.StudioComponentState]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.states())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.nimble.model.StudioComponentState.wrap(item)
          }.toList
        )
    override val studioId: String = impl.studioId(): String
    override val types
        : Optional[List[zio.aws.nimble.model.StudioComponentType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.types())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.nimble.model.StudioComponentType.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.ListStudioComponentsRequest
  ): zio.aws.nimble.model.ListStudioComponentsRequest.ReadOnly = new Wrapper(
    impl
  )
}
