package zio.aws.nimble.model
import zio.aws.nimble.model.primitives.{
  WindowsMountDrive,
  LinuxMountPoint,
  SensitiveString
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SharedFileSystemConfiguration(
    endpoint: Optional[SensitiveString] = Optional.Absent,
    fileSystemId: Optional[String] = Optional.Absent,
    linuxMountPoint: Optional[LinuxMountPoint] = Optional.Absent,
    shareName: Optional[SensitiveString] = Optional.Absent,
    windowsMountDrive: Optional[WindowsMountDrive] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.SharedFileSystemConfiguration = {
    import SharedFileSystemConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.SharedFileSystemConfiguration
      .builder()
      .optionallyWith(
        endpoint.map(value => SensitiveString.unwrap(value): java.lang.String)
      )(_.endpoint)
      .optionallyWith(fileSystemId.map(value => value: java.lang.String))(
        _.fileSystemId
      )
      .optionallyWith(
        linuxMountPoint.map(value =>
          LinuxMountPoint.unwrap(value): java.lang.String
        )
      )(_.linuxMountPoint)
      .optionallyWith(
        shareName.map(value => SensitiveString.unwrap(value): java.lang.String)
      )(_.shareName)
      .optionallyWith(
        windowsMountDrive.map(value =>
          WindowsMountDrive.unwrap(value): java.lang.String
        )
      )(_.windowsMountDrive)
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.SharedFileSystemConfiguration.ReadOnly =
    zio.aws.nimble.model.SharedFileSystemConfiguration.wrap(buildAwsValue())
}
object SharedFileSystemConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.SharedFileSystemConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.SharedFileSystemConfiguration =
      zio.aws.nimble.model.SharedFileSystemConfiguration(
        endpoint.map(value => value),
        fileSystemId.map(value => value),
        linuxMountPoint.map(value => value),
        shareName.map(value => value),
        windowsMountDrive.map(value => value)
      )
    def endpoint: Optional[SensitiveString]
    def fileSystemId: Optional[String]
    def linuxMountPoint: Optional[LinuxMountPoint]
    def shareName: Optional[SensitiveString]
    def windowsMountDrive: Optional[WindowsMountDrive]
    def getEndpoint: ZIO[Any, AwsError, SensitiveString] =
      AwsError.unwrapOptionField("endpoint", endpoint)
    def getFileSystemId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("fileSystemId", fileSystemId)
    def getLinuxMountPoint: ZIO[Any, AwsError, LinuxMountPoint] =
      AwsError.unwrapOptionField("linuxMountPoint", linuxMountPoint)
    def getShareName: ZIO[Any, AwsError, SensitiveString] =
      AwsError.unwrapOptionField("shareName", shareName)
    def getWindowsMountDrive: ZIO[Any, AwsError, WindowsMountDrive] =
      AwsError.unwrapOptionField("windowsMountDrive", windowsMountDrive)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.SharedFileSystemConfiguration
  ) extends zio.aws.nimble.model.SharedFileSystemConfiguration.ReadOnly {
    override val endpoint: Optional[SensitiveString] = zio.aws.core.internal
      .optionalFromNullable(impl.endpoint())
      .map(value => zio.aws.nimble.model.primitives.SensitiveString(value))
    override val fileSystemId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.fileSystemId())
      .map(value => value: String)
    override val linuxMountPoint: Optional[LinuxMountPoint] =
      zio.aws.core.internal
        .optionalFromNullable(impl.linuxMountPoint())
        .map(value => zio.aws.nimble.model.primitives.LinuxMountPoint(value))
    override val shareName: Optional[SensitiveString] = zio.aws.core.internal
      .optionalFromNullable(impl.shareName())
      .map(value => zio.aws.nimble.model.primitives.SensitiveString(value))
    override val windowsMountDrive: Optional[WindowsMountDrive] =
      zio.aws.core.internal
        .optionalFromNullable(impl.windowsMountDrive())
        .map(value => zio.aws.nimble.model.primitives.WindowsMountDrive(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.SharedFileSystemConfiguration
  ): zio.aws.nimble.model.SharedFileSystemConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
