package zio.aws.nimble.model
import zio.aws.nimble.model.primitives.{
  StreamingImageId,
  EC2ImageId,
  StreamingImagePlatform,
  StreamingImageOwner,
  StreamingImageName,
  StreamingImageDescription
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StreamingImage(
    arn: Optional[String] = Optional.Absent,
    description: Optional[StreamingImageDescription] = Optional.Absent,
    ec2ImageId: Optional[EC2ImageId] = Optional.Absent,
    encryptionConfiguration: Optional[
      zio.aws.nimble.model.StreamingImageEncryptionConfiguration
    ] = Optional.Absent,
    eulaIds: Optional[Iterable[String]] = Optional.Absent,
    name: Optional[StreamingImageName] = Optional.Absent,
    owner: Optional[StreamingImageOwner] = Optional.Absent,
    platform: Optional[StreamingImagePlatform] = Optional.Absent,
    state: Optional[zio.aws.nimble.model.StreamingImageState] = Optional.Absent,
    statusCode: Optional[zio.aws.nimble.model.StreamingImageStatusCode] =
      Optional.Absent,
    statusMessage: Optional[String] = Optional.Absent,
    streamingImageId: Optional[StreamingImageId] = Optional.Absent,
    tags: Optional[Map[String, String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.StreamingImage = {
    import StreamingImage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.StreamingImage
      .builder()
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(
        description.map(value =>
          StreamingImageDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        ec2ImageId.map(value => EC2ImageId.unwrap(value): java.lang.String)
      )(_.ec2ImageId)
      .optionallyWith(
        encryptionConfiguration.map(value => value.buildAwsValue())
      )(_.encryptionConfiguration)
      .optionallyWith(
        eulaIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.eulaIds)
      .optionallyWith(
        name.map(value => StreamingImageName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        owner.map(value => StreamingImageOwner.unwrap(value): java.lang.String)
      )(_.owner)
      .optionallyWith(
        platform.map(value =>
          StreamingImagePlatform.unwrap(value): java.lang.String
        )
      )(_.platform)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(statusCode.map(value => value.unwrap))(_.statusCode)
      .optionallyWith(statusMessage.map(value => value: java.lang.String))(
        _.statusMessage
      )
      .optionallyWith(
        streamingImageId.map(value =>
          StreamingImageId.unwrap(value): java.lang.String
        )
      )(_.streamingImageId)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.StreamingImage.ReadOnly =
    zio.aws.nimble.model.StreamingImage.wrap(buildAwsValue())
}
object StreamingImage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.StreamingImage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.StreamingImage =
      zio.aws.nimble.model.StreamingImage(
        arn.map(value => value),
        description.map(value => value),
        ec2ImageId.map(value => value),
        encryptionConfiguration.map(value => value.asEditable),
        eulaIds.map(value => value),
        name.map(value => value),
        owner.map(value => value),
        platform.map(value => value),
        state.map(value => value),
        statusCode.map(value => value),
        statusMessage.map(value => value),
        streamingImageId.map(value => value),
        tags.map(value => value)
      )
    def arn: Optional[String]
    def description: Optional[StreamingImageDescription]
    def ec2ImageId: Optional[EC2ImageId]
    def encryptionConfiguration: Optional[
      zio.aws.nimble.model.StreamingImageEncryptionConfiguration.ReadOnly
    ]
    def eulaIds: Optional[List[String]]
    def name: Optional[StreamingImageName]
    def owner: Optional[StreamingImageOwner]
    def platform: Optional[StreamingImagePlatform]
    def state: Optional[zio.aws.nimble.model.StreamingImageState]
    def statusCode: Optional[zio.aws.nimble.model.StreamingImageStatusCode]
    def statusMessage: Optional[String]
    def streamingImageId: Optional[StreamingImageId]
    def tags: Optional[Map[String, String]]
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
    def getDescription: ZIO[Any, AwsError, StreamingImageDescription] =
      AwsError.unwrapOptionField("description", description)
    def getEc2ImageId: ZIO[Any, AwsError, EC2ImageId] =
      AwsError.unwrapOptionField("ec2ImageId", ec2ImageId)
    def getEncryptionConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.nimble.model.StreamingImageEncryptionConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "encryptionConfiguration",
      encryptionConfiguration
    )
    def getEulaIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("eulaIds", eulaIds)
    def getName: ZIO[Any, AwsError, StreamingImageName] =
      AwsError.unwrapOptionField("name", name)
    def getOwner: ZIO[Any, AwsError, StreamingImageOwner] =
      AwsError.unwrapOptionField("owner", owner)
    def getPlatform: ZIO[Any, AwsError, StreamingImagePlatform] =
      AwsError.unwrapOptionField("platform", platform)
    def getState: ZIO[Any, AwsError, zio.aws.nimble.model.StreamingImageState] =
      AwsError.unwrapOptionField("state", state)
    def getStatusCode
        : ZIO[Any, AwsError, zio.aws.nimble.model.StreamingImageStatusCode] =
      AwsError.unwrapOptionField("statusCode", statusCode)
    def getStatusMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getStreamingImageId: ZIO[Any, AwsError, StreamingImageId] =
      AwsError.unwrapOptionField("streamingImageId", streamingImageId)
    def getTags: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.StreamingImage
  ) extends zio.aws.nimble.model.StreamingImage.ReadOnly {
    override val arn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: String)
    override val description: Optional[StreamingImageDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.nimble.model.primitives.StreamingImageDescription(value)
        )
    override val ec2ImageId: Optional[EC2ImageId] = zio.aws.core.internal
      .optionalFromNullable(impl.ec2ImageId())
      .map(value => zio.aws.nimble.model.primitives.EC2ImageId(value))
    override val encryptionConfiguration: Optional[
      zio.aws.nimble.model.StreamingImageEncryptionConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.encryptionConfiguration())
      .map(value =>
        zio.aws.nimble.model.StreamingImageEncryptionConfiguration.wrap(value)
      )
    override val eulaIds: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.eulaIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val name: Optional[StreamingImageName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.nimble.model.primitives.StreamingImageName(value))
    override val owner: Optional[StreamingImageOwner] = zio.aws.core.internal
      .optionalFromNullable(impl.owner())
      .map(value => zio.aws.nimble.model.primitives.StreamingImageOwner(value))
    override val platform: Optional[StreamingImagePlatform] =
      zio.aws.core.internal
        .optionalFromNullable(impl.platform())
        .map(value =>
          zio.aws.nimble.model.primitives.StreamingImagePlatform(value)
        )
    override val state: Optional[zio.aws.nimble.model.StreamingImageState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.nimble.model.StreamingImageState.wrap(value))
    override val statusCode
        : Optional[zio.aws.nimble.model.StreamingImageStatusCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusCode())
        .map(value => zio.aws.nimble.model.StreamingImageStatusCode.wrap(value))
    override val statusMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.statusMessage())
      .map(value => value: String)
    override val streamingImageId: Optional[StreamingImageId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.streamingImageId())
        .map(value => zio.aws.nimble.model.primitives.StreamingImageId(value))
    override val tags: Optional[Map[String, String]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.StreamingImage
  ): zio.aws.nimble.model.StreamingImage.ReadOnly = new Wrapper(impl)
}
