package zio.aws.nimble.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.nimble.model.primitives.{
  RoleArn,
  SecurityGroupId,
  Timestamp,
  StudioComponentDescription,
  StudioComponentName,
  StudioComponentId
}
import scala.jdk.CollectionConverters._
final case class StudioComponent(
    arn: Optional[String] = Optional.Absent,
    configuration: Optional[zio.aws.nimble.model.StudioComponentConfiguration] =
      Optional.Absent,
    createdAt: Optional[Timestamp] = Optional.Absent,
    createdBy: Optional[String] = Optional.Absent,
    description: Optional[StudioComponentDescription] = Optional.Absent,
    ec2SecurityGroupIds: Optional[Iterable[SecurityGroupId]] = Optional.Absent,
    initializationScripts: Optional[
      Iterable[zio.aws.nimble.model.StudioComponentInitializationScript]
    ] = Optional.Absent,
    name: Optional[StudioComponentName] = Optional.Absent,
    runtimeRoleArn: Optional[RoleArn] = Optional.Absent,
    scriptParameters: Optional[
      Iterable[zio.aws.nimble.model.ScriptParameterKeyValue]
    ] = Optional.Absent,
    secureInitializationRoleArn: Optional[RoleArn] = Optional.Absent,
    state: Optional[zio.aws.nimble.model.StudioComponentState] =
      Optional.Absent,
    statusCode: Optional[zio.aws.nimble.model.StudioComponentStatusCode] =
      Optional.Absent,
    statusMessage: Optional[String] = Optional.Absent,
    studioComponentId: Optional[StudioComponentId] = Optional.Absent,
    subtype: Optional[zio.aws.nimble.model.StudioComponentSubtype] =
      Optional.Absent,
    tags: Optional[Map[String, String]] = Optional.Absent,
    `type`: Optional[zio.aws.nimble.model.StudioComponentType] =
      Optional.Absent,
    updatedAt: Optional[Timestamp] = Optional.Absent,
    updatedBy: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.StudioComponent = {
    import StudioComponent.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.StudioComponent
      .builder()
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(configuration.map(value => value.buildAwsValue()))(
        _.configuration
      )
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(createdBy.map(value => value: java.lang.String))(
        _.createdBy
      )
      .optionallyWith(
        description.map(value =>
          StudioComponentDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        ec2SecurityGroupIds.map(value =>
          value.map { item =>
            SecurityGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.ec2SecurityGroupIds)
      .optionallyWith(
        initializationScripts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.initializationScripts)
      .optionallyWith(
        name.map(value => StudioComponentName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        runtimeRoleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.runtimeRoleArn)
      .optionallyWith(
        scriptParameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.scriptParameters)
      .optionallyWith(
        secureInitializationRoleArn.map(value =>
          RoleArn.unwrap(value): java.lang.String
        )
      )(_.secureInitializationRoleArn)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(statusCode.map(value => value.unwrap))(_.statusCode)
      .optionallyWith(statusMessage.map(value => value: java.lang.String))(
        _.statusMessage
      )
      .optionallyWith(
        studioComponentId.map(value =>
          StudioComponentId.unwrap(value): java.lang.String
        )
      )(_.studioComponentId)
      .optionallyWith(subtype.map(value => value.unwrap))(_.subtype)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(updatedAt.map(value => Timestamp.unwrap(value): Instant))(
        _.updatedAt
      )
      .optionallyWith(updatedBy.map(value => value: java.lang.String))(
        _.updatedBy
      )
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.StudioComponent.ReadOnly =
    zio.aws.nimble.model.StudioComponent.wrap(buildAwsValue())
}
object StudioComponent {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.StudioComponent
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.StudioComponent =
      zio.aws.nimble.model.StudioComponent(
        arn.map(value => value),
        configuration.map(value => value.asEditable),
        createdAt.map(value => value),
        createdBy.map(value => value),
        description.map(value => value),
        ec2SecurityGroupIds.map(value => value),
        initializationScripts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        name.map(value => value),
        runtimeRoleArn.map(value => value),
        scriptParameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        secureInitializationRoleArn.map(value => value),
        state.map(value => value),
        statusCode.map(value => value),
        statusMessage.map(value => value),
        studioComponentId.map(value => value),
        subtype.map(value => value),
        tags.map(value => value),
        `type`.map(value => value),
        updatedAt.map(value => value),
        updatedBy.map(value => value)
      )
    def arn: Optional[String]
    def configuration
        : Optional[zio.aws.nimble.model.StudioComponentConfiguration.ReadOnly]
    def createdAt: Optional[Timestamp]
    def createdBy: Optional[String]
    def description: Optional[StudioComponentDescription]
    def ec2SecurityGroupIds: Optional[List[SecurityGroupId]]
    def initializationScripts: Optional[
      List[zio.aws.nimble.model.StudioComponentInitializationScript.ReadOnly]
    ]
    def name: Optional[StudioComponentName]
    def runtimeRoleArn: Optional[RoleArn]
    def scriptParameters
        : Optional[List[zio.aws.nimble.model.ScriptParameterKeyValue.ReadOnly]]
    def secureInitializationRoleArn: Optional[RoleArn]
    def state: Optional[zio.aws.nimble.model.StudioComponentState]
    def statusCode: Optional[zio.aws.nimble.model.StudioComponentStatusCode]
    def statusMessage: Optional[String]
    def studioComponentId: Optional[StudioComponentId]
    def subtype: Optional[zio.aws.nimble.model.StudioComponentSubtype]
    def tags: Optional[Map[String, String]]
    def `type`: Optional[zio.aws.nimble.model.StudioComponentType]
    def updatedAt: Optional[Timestamp]
    def updatedBy: Optional[String]
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
    def getConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.nimble.model.StudioComponentConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("configuration", configuration)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getCreatedBy: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("createdBy", createdBy)
    def getDescription: ZIO[Any, AwsError, StudioComponentDescription] =
      AwsError.unwrapOptionField("description", description)
    def getEc2SecurityGroupIds: ZIO[Any, AwsError, List[SecurityGroupId]] =
      AwsError.unwrapOptionField("ec2SecurityGroupIds", ec2SecurityGroupIds)
    def getInitializationScripts: ZIO[Any, AwsError, List[
      zio.aws.nimble.model.StudioComponentInitializationScript.ReadOnly
    ]] =
      AwsError.unwrapOptionField("initializationScripts", initializationScripts)
    def getName: ZIO[Any, AwsError, StudioComponentName] =
      AwsError.unwrapOptionField("name", name)
    def getRuntimeRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("runtimeRoleArn", runtimeRoleArn)
    def getScriptParameters: ZIO[Any, AwsError, List[
      zio.aws.nimble.model.ScriptParameterKeyValue.ReadOnly
    ]] = AwsError.unwrapOptionField("scriptParameters", scriptParameters)
    def getSecureInitializationRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField(
        "secureInitializationRoleArn",
        secureInitializationRoleArn
      )
    def getState
        : ZIO[Any, AwsError, zio.aws.nimble.model.StudioComponentState] =
      AwsError.unwrapOptionField("state", state)
    def getStatusCode
        : ZIO[Any, AwsError, zio.aws.nimble.model.StudioComponentStatusCode] =
      AwsError.unwrapOptionField("statusCode", statusCode)
    def getStatusMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getStudioComponentId: ZIO[Any, AwsError, StudioComponentId] =
      AwsError.unwrapOptionField("studioComponentId", studioComponentId)
    def getSubtype
        : ZIO[Any, AwsError, zio.aws.nimble.model.StudioComponentSubtype] =
      AwsError.unwrapOptionField("subtype", subtype)
    def getTags: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("tags", tags)
    def getType: ZIO[Any, AwsError, zio.aws.nimble.model.StudioComponentType] =
      AwsError.unwrapOptionField("type", `type`)
    def getUpdatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
    def getUpdatedBy: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("updatedBy", updatedBy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.StudioComponent
  ) extends zio.aws.nimble.model.StudioComponent.ReadOnly {
    override val arn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: String)
    override val configuration
        : Optional[zio.aws.nimble.model.StudioComponentConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.configuration())
        .map(value =>
          zio.aws.nimble.model.StudioComponentConfiguration.wrap(value)
        )
    override val createdAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.nimble.model.primitives.Timestamp(value))
    override val createdBy: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.createdBy())
      .map(value => value: String)
    override val description: Optional[StudioComponentDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.nimble.model.primitives.StudioComponentDescription(value)
        )
    override val ec2SecurityGroupIds: Optional[List[SecurityGroupId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ec2SecurityGroupIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.nimble.model.primitives.SecurityGroupId(item)
          }.toList
        )
    override val initializationScripts: Optional[
      List[zio.aws.nimble.model.StudioComponentInitializationScript.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.initializationScripts())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.nimble.model.StudioComponentInitializationScript.wrap(item)
        }.toList
      )
    override val name: Optional[StudioComponentName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.nimble.model.primitives.StudioComponentName(value))
    override val runtimeRoleArn: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.runtimeRoleArn())
      .map(value => zio.aws.nimble.model.primitives.RoleArn(value))
    override val scriptParameters: Optional[
      List[zio.aws.nimble.model.ScriptParameterKeyValue.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.scriptParameters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.nimble.model.ScriptParameterKeyValue.wrap(item)
        }.toList
      )
    override val secureInitializationRoleArn: Optional[RoleArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.secureInitializationRoleArn())
        .map(value => zio.aws.nimble.model.primitives.RoleArn(value))
    override val state: Optional[zio.aws.nimble.model.StudioComponentState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.nimble.model.StudioComponentState.wrap(value))
    override val statusCode
        : Optional[zio.aws.nimble.model.StudioComponentStatusCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusCode())
        .map(value =>
          zio.aws.nimble.model.StudioComponentStatusCode.wrap(value)
        )
    override val statusMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.statusMessage())
      .map(value => value: String)
    override val studioComponentId: Optional[StudioComponentId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.studioComponentId())
        .map(value => zio.aws.nimble.model.primitives.StudioComponentId(value))
    override val subtype
        : Optional[zio.aws.nimble.model.StudioComponentSubtype] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subtype())
        .map(value => zio.aws.nimble.model.StudioComponentSubtype.wrap(value))
    override val tags: Optional[Map[String, String]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override val `type`: Optional[zio.aws.nimble.model.StudioComponentType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.nimble.model.StudioComponentType.wrap(value))
    override val updatedAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedAt())
      .map(value => zio.aws.nimble.model.primitives.Timestamp(value))
    override val updatedBy: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedBy())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.StudioComponent
  ): zio.aws.nimble.model.StudioComponent.ReadOnly = new Wrapper(impl)
}
