package zio.aws.nimble.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StudioComponentConfiguration(
    activeDirectoryConfiguration: Optional[
      zio.aws.nimble.model.ActiveDirectoryConfiguration
    ] = Optional.Absent,
    computeFarmConfiguration: Optional[
      zio.aws.nimble.model.ComputeFarmConfiguration
    ] = Optional.Absent,
    licenseServiceConfiguration: Optional[
      zio.aws.nimble.model.LicenseServiceConfiguration
    ] = Optional.Absent,
    sharedFileSystemConfiguration: Optional[
      zio.aws.nimble.model.SharedFileSystemConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.StudioComponentConfiguration = {
    import StudioComponentConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.StudioComponentConfiguration
      .builder()
      .optionallyWith(
        activeDirectoryConfiguration.map(value => value.buildAwsValue())
      )(_.activeDirectoryConfiguration)
      .optionallyWith(
        computeFarmConfiguration.map(value => value.buildAwsValue())
      )(_.computeFarmConfiguration)
      .optionallyWith(
        licenseServiceConfiguration.map(value => value.buildAwsValue())
      )(_.licenseServiceConfiguration)
      .optionallyWith(
        sharedFileSystemConfiguration.map(value => value.buildAwsValue())
      )(_.sharedFileSystemConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.StudioComponentConfiguration.ReadOnly =
    zio.aws.nimble.model.StudioComponentConfiguration.wrap(buildAwsValue())
}
object StudioComponentConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.StudioComponentConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.StudioComponentConfiguration =
      zio.aws.nimble.model.StudioComponentConfiguration(
        activeDirectoryConfiguration.map(value => value.asEditable),
        computeFarmConfiguration.map(value => value.asEditable),
        licenseServiceConfiguration.map(value => value.asEditable),
        sharedFileSystemConfiguration.map(value => value.asEditable)
      )
    def activeDirectoryConfiguration
        : Optional[zio.aws.nimble.model.ActiveDirectoryConfiguration.ReadOnly]
    def computeFarmConfiguration
        : Optional[zio.aws.nimble.model.ComputeFarmConfiguration.ReadOnly]
    def licenseServiceConfiguration
        : Optional[zio.aws.nimble.model.LicenseServiceConfiguration.ReadOnly]
    def sharedFileSystemConfiguration
        : Optional[zio.aws.nimble.model.SharedFileSystemConfiguration.ReadOnly]
    def getActiveDirectoryConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.nimble.model.ActiveDirectoryConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "activeDirectoryConfiguration",
      activeDirectoryConfiguration
    )
    def getComputeFarmConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.nimble.model.ComputeFarmConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "computeFarmConfiguration",
      computeFarmConfiguration
    )
    def getLicenseServiceConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.nimble.model.LicenseServiceConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "licenseServiceConfiguration",
      licenseServiceConfiguration
    )
    def getSharedFileSystemConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.nimble.model.SharedFileSystemConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "sharedFileSystemConfiguration",
      sharedFileSystemConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.StudioComponentConfiguration
  ) extends zio.aws.nimble.model.StudioComponentConfiguration.ReadOnly {
    override val activeDirectoryConfiguration
        : Optional[zio.aws.nimble.model.ActiveDirectoryConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.activeDirectoryConfiguration())
        .map(value =>
          zio.aws.nimble.model.ActiveDirectoryConfiguration.wrap(value)
        )
    override val computeFarmConfiguration
        : Optional[zio.aws.nimble.model.ComputeFarmConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.computeFarmConfiguration())
        .map(value => zio.aws.nimble.model.ComputeFarmConfiguration.wrap(value))
    override val licenseServiceConfiguration
        : Optional[zio.aws.nimble.model.LicenseServiceConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.licenseServiceConfiguration())
        .map(value =>
          zio.aws.nimble.model.LicenseServiceConfiguration.wrap(value)
        )
    override val sharedFileSystemConfiguration: Optional[
      zio.aws.nimble.model.SharedFileSystemConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sharedFileSystemConfiguration())
      .map(value =>
        zio.aws.nimble.model.SharedFileSystemConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.StudioComponentConfiguration
  ): zio.aws.nimble.model.StudioComponentConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
