package zio.aws.nimble.model
import zio.aws.nimble.model.primitives.{
  LaunchProfileName,
  LaunchProfileProtocolVersion,
  LaunchProfileDescription,
  ClientToken
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateLaunchProfileRequest(
    clientToken: Optional[ClientToken] = Optional.Absent,
    description: Optional[LaunchProfileDescription] = Optional.Absent,
    launchProfileId: String,
    launchProfileProtocolVersions: Optional[
      Iterable[LaunchProfileProtocolVersion]
    ] = Optional.Absent,
    name: Optional[LaunchProfileName] = Optional.Absent,
    streamConfiguration: Optional[
      zio.aws.nimble.model.StreamConfigurationCreate
    ] = Optional.Absent,
    studioComponentIds: Optional[Iterable[String]] = Optional.Absent,
    studioId: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.UpdateLaunchProfileRequest = {
    import UpdateLaunchProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.UpdateLaunchProfileRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(
        description.map(value =>
          LaunchProfileDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .launchProfileId(launchProfileId: java.lang.String)
      .optionallyWith(
        launchProfileProtocolVersions.map(value =>
          value.map { item =>
            LaunchProfileProtocolVersion.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.launchProfileProtocolVersions)
      .optionallyWith(
        name.map(value => LaunchProfileName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(streamConfiguration.map(value => value.buildAwsValue()))(
        _.streamConfiguration
      )
      .optionallyWith(
        studioComponentIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.studioComponentIds)
      .studioId(studioId: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.UpdateLaunchProfileRequest.ReadOnly =
    zio.aws.nimble.model.UpdateLaunchProfileRequest.wrap(buildAwsValue())
}
object UpdateLaunchProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.UpdateLaunchProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.UpdateLaunchProfileRequest =
      zio.aws.nimble.model.UpdateLaunchProfileRequest(
        clientToken.map(value => value),
        description.map(value => value),
        launchProfileId,
        launchProfileProtocolVersions.map(value => value),
        name.map(value => value),
        streamConfiguration.map(value => value.asEditable),
        studioComponentIds.map(value => value),
        studioId
      )
    def clientToken: Optional[ClientToken]
    def description: Optional[LaunchProfileDescription]
    def launchProfileId: String
    def launchProfileProtocolVersions
        : Optional[List[LaunchProfileProtocolVersion]]
    def name: Optional[LaunchProfileName]
    def streamConfiguration
        : Optional[zio.aws.nimble.model.StreamConfigurationCreate.ReadOnly]
    def studioComponentIds: Optional[List[String]]
    def studioId: String
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getDescription: ZIO[Any, AwsError, LaunchProfileDescription] =
      AwsError.unwrapOptionField("description", description)
    def getLaunchProfileId: ZIO[Any, Nothing, String] =
      ZIO.succeed(launchProfileId)
    def getLaunchProfileProtocolVersions
        : ZIO[Any, AwsError, List[LaunchProfileProtocolVersion]] =
      AwsError.unwrapOptionField(
        "launchProfileProtocolVersions",
        launchProfileProtocolVersions
      )
    def getName: ZIO[Any, AwsError, LaunchProfileName] =
      AwsError.unwrapOptionField("name", name)
    def getStreamConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.nimble.model.StreamConfigurationCreate.ReadOnly
    ] = AwsError.unwrapOptionField("streamConfiguration", streamConfiguration)
    def getStudioComponentIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("studioComponentIds", studioComponentIds)
    def getStudioId: ZIO[Any, Nothing, String] = ZIO.succeed(studioId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.UpdateLaunchProfileRequest
  ) extends zio.aws.nimble.model.UpdateLaunchProfileRequest.ReadOnly {
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.nimble.model.primitives.ClientToken(value))
    override val description: Optional[LaunchProfileDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.nimble.model.primitives.LaunchProfileDescription(value)
        )
    override val launchProfileId: String = impl.launchProfileId(): String
    override val launchProfileProtocolVersions
        : Optional[List[LaunchProfileProtocolVersion]] = zio.aws.core.internal
      .optionalFromNullable(impl.launchProfileProtocolVersions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.nimble.model.primitives.LaunchProfileProtocolVersion(item)
        }.toList
      )
    override val name: Optional[LaunchProfileName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.nimble.model.primitives.LaunchProfileName(value))
    override val streamConfiguration
        : Optional[zio.aws.nimble.model.StreamConfigurationCreate.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.streamConfiguration())
        .map(value =>
          zio.aws.nimble.model.StreamConfigurationCreate.wrap(value)
        )
    override val studioComponentIds: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.studioComponentIds())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val studioId: String = impl.studioId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.UpdateLaunchProfileRequest
  ): zio.aws.nimble.model.UpdateLaunchProfileRequest.ReadOnly = new Wrapper(
    impl
  )
}
