package zio.aws.nimble.model
import zio.aws.nimble.model.primitives.{StudioDisplayName, ClientToken, RoleArn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateStudioRequest(
    adminRoleArn: Optional[RoleArn] = Optional.Absent,
    clientToken: Optional[ClientToken] = Optional.Absent,
    displayName: Optional[StudioDisplayName] = Optional.Absent,
    studioId: String,
    userRoleArn: Optional[RoleArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.UpdateStudioRequest = {
    import UpdateStudioRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.UpdateStudioRequest
      .builder()
      .optionallyWith(
        adminRoleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.adminRoleArn)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(
        displayName.map(value =>
          StudioDisplayName.unwrap(value): java.lang.String
        )
      )(_.displayName)
      .studioId(studioId: java.lang.String)
      .optionallyWith(
        userRoleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.userRoleArn)
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.UpdateStudioRequest.ReadOnly =
    zio.aws.nimble.model.UpdateStudioRequest.wrap(buildAwsValue())
}
object UpdateStudioRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.UpdateStudioRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.UpdateStudioRequest =
      zio.aws.nimble.model.UpdateStudioRequest(
        adminRoleArn.map(value => value),
        clientToken.map(value => value),
        displayName.map(value => value),
        studioId,
        userRoleArn.map(value => value)
      )
    def adminRoleArn: Optional[RoleArn]
    def clientToken: Optional[ClientToken]
    def displayName: Optional[StudioDisplayName]
    def studioId: String
    def userRoleArn: Optional[RoleArn]
    def getAdminRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("adminRoleArn", adminRoleArn)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getDisplayName: ZIO[Any, AwsError, StudioDisplayName] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getStudioId: ZIO[Any, Nothing, String] = ZIO.succeed(studioId)
    def getUserRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("userRoleArn", userRoleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.UpdateStudioRequest
  ) extends zio.aws.nimble.model.UpdateStudioRequest.ReadOnly {
    override val adminRoleArn: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.adminRoleArn())
      .map(value => zio.aws.nimble.model.primitives.RoleArn(value))
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.nimble.model.primitives.ClientToken(value))
    override val displayName: Optional[StudioDisplayName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.displayName())
        .map(value => zio.aws.nimble.model.primitives.StudioDisplayName(value))
    override val studioId: String = impl.studioId(): String
    override val userRoleArn: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.userRoleArn())
      .map(value => zio.aws.nimble.model.primitives.RoleArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.UpdateStudioRequest
  ): zio.aws.nimble.model.UpdateStudioRequest.ReadOnly = new Wrapper(impl)
}
