package zio.aws.nimble.model
import scala.jdk.CollectionConverters._
sealed trait AutomaticTerminationMode {
  def unwrap
      : software.amazon.awssdk.services.nimble.model.AutomaticTerminationMode
}
object AutomaticTerminationMode {
  def wrap(
      value: software.amazon.awssdk.services.nimble.model.AutomaticTerminationMode
  ): zio.aws.nimble.model.AutomaticTerminationMode = value match {
    case software.amazon.awssdk.services.nimble.model.AutomaticTerminationMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.nimble.model.AutomaticTerminationMode.DEACTIVATED =>
      val r = DEACTIVATED
      r
    case software.amazon.awssdk.services.nimble.model.AutomaticTerminationMode.ACTIVATED =>
      val r = ACTIVATED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.nimble.model.AutomaticTerminationMode {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.AutomaticTerminationMode =
      software.amazon.awssdk.services.nimble.model.AutomaticTerminationMode.UNKNOWN_TO_SDK_VERSION
  }
  case object DEACTIVATED
      extends zio.aws.nimble.model.AutomaticTerminationMode {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.AutomaticTerminationMode =
      software.amazon.awssdk.services.nimble.model.AutomaticTerminationMode.DEACTIVATED
  }
  case object ACTIVATED extends zio.aws.nimble.model.AutomaticTerminationMode {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.AutomaticTerminationMode =
      software.amazon.awssdk.services.nimble.model.AutomaticTerminationMode.ACTIVATED
  }
}
