package zio.aws.nimble.model
import zio.aws.nimble.model.primitives.SensitiveString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ComputeFarmConfiguration(
    activeDirectoryUser: Optional[String] = Optional.Absent,
    endpoint: Optional[SensitiveString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.ComputeFarmConfiguration = {
    import ComputeFarmConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.ComputeFarmConfiguration
      .builder()
      .optionallyWith(
        activeDirectoryUser.map(value => value: java.lang.String)
      )(_.activeDirectoryUser)
      .optionallyWith(
        endpoint.map(value => SensitiveString.unwrap(value): java.lang.String)
      )(_.endpoint)
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.ComputeFarmConfiguration.ReadOnly =
    zio.aws.nimble.model.ComputeFarmConfiguration.wrap(buildAwsValue())
}
object ComputeFarmConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.ComputeFarmConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.ComputeFarmConfiguration =
      zio.aws.nimble.model.ComputeFarmConfiguration(
        activeDirectoryUser.map(value => value),
        endpoint.map(value => value)
      )
    def activeDirectoryUser: Optional[String]
    def endpoint: Optional[SensitiveString]
    def getActiveDirectoryUser: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("activeDirectoryUser", activeDirectoryUser)
    def getEndpoint: ZIO[Any, AwsError, SensitiveString] =
      AwsError.unwrapOptionField("endpoint", endpoint)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.ComputeFarmConfiguration
  ) extends zio.aws.nimble.model.ComputeFarmConfiguration.ReadOnly {
    override val activeDirectoryUser: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.activeDirectoryUser())
      .map(value => value: String)
    override val endpoint: Optional[SensitiveString] = zio.aws.core.internal
      .optionalFromNullable(impl.endpoint())
      .map(value => zio.aws.nimble.model.primitives.SensitiveString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.ComputeFarmConfiguration
  ): zio.aws.nimble.model.ComputeFarmConfiguration.ReadOnly = new Wrapper(impl)
}
