package zio.aws.nimble.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateStreamingSessionStreamResponse(
    stream: Optional[zio.aws.nimble.model.StreamingSessionStream] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.CreateStreamingSessionStreamResponse = {
    import CreateStreamingSessionStreamResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.CreateStreamingSessionStreamResponse
      .builder()
      .optionallyWith(stream.map(value => value.buildAwsValue()))(_.stream)
      .build()
  }
  def asReadOnly
      : zio.aws.nimble.model.CreateStreamingSessionStreamResponse.ReadOnly =
    zio.aws.nimble.model.CreateStreamingSessionStreamResponse
      .wrap(buildAwsValue())
}
object CreateStreamingSessionStreamResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.CreateStreamingSessionStreamResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.CreateStreamingSessionStreamResponse =
      zio.aws.nimble.model.CreateStreamingSessionStreamResponse(
        stream.map(value => value.asEditable)
      )
    def stream: Optional[zio.aws.nimble.model.StreamingSessionStream.ReadOnly]
    def getStream: ZIO[
      Any,
      AwsError,
      zio.aws.nimble.model.StreamingSessionStream.ReadOnly
    ] = AwsError.unwrapOptionField("stream", stream)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.CreateStreamingSessionStreamResponse
  ) extends zio.aws.nimble.model.CreateStreamingSessionStreamResponse.ReadOnly {
    override val stream
        : Optional[zio.aws.nimble.model.StreamingSessionStream.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stream())
        .map(value => zio.aws.nimble.model.StreamingSessionStream.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.CreateStreamingSessionStreamResponse
  ): zio.aws.nimble.model.CreateStreamingSessionStreamResponse.ReadOnly =
    new Wrapper(impl)
}
