package zio.aws.nimble.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetStreamingSessionBackupResponse(
    streamingSessionBackup: Optional[
      zio.aws.nimble.model.StreamingSessionBackup
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.GetStreamingSessionBackupResponse = {
    import GetStreamingSessionBackupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.GetStreamingSessionBackupResponse
      .builder()
      .optionallyWith(
        streamingSessionBackup.map(value => value.buildAwsValue())
      )(_.streamingSessionBackup)
      .build()
  }
  def asReadOnly
      : zio.aws.nimble.model.GetStreamingSessionBackupResponse.ReadOnly =
    zio.aws.nimble.model.GetStreamingSessionBackupResponse.wrap(buildAwsValue())
}
object GetStreamingSessionBackupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.GetStreamingSessionBackupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.GetStreamingSessionBackupResponse =
      zio.aws.nimble.model.GetStreamingSessionBackupResponse(
        streamingSessionBackup.map(value => value.asEditable)
      )
    def streamingSessionBackup
        : Optional[zio.aws.nimble.model.StreamingSessionBackup.ReadOnly]
    def getStreamingSessionBackup: ZIO[
      Any,
      AwsError,
      zio.aws.nimble.model.StreamingSessionBackup.ReadOnly
    ] = AwsError.unwrapOptionField(
      "streamingSessionBackup",
      streamingSessionBackup
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.GetStreamingSessionBackupResponse
  ) extends zio.aws.nimble.model.GetStreamingSessionBackupResponse.ReadOnly {
    override val streamingSessionBackup
        : Optional[zio.aws.nimble.model.StreamingSessionBackup.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.streamingSessionBackup())
        .map(value => zio.aws.nimble.model.StreamingSessionBackup.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.GetStreamingSessionBackupResponse
  ): zio.aws.nimble.model.GetStreamingSessionBackupResponse.ReadOnly =
    new Wrapper(impl)
}
