package zio.aws.nimble.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetStreamingSessionStreamResponse(
    stream: Optional[zio.aws.nimble.model.StreamingSessionStream] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.GetStreamingSessionStreamResponse = {
    import GetStreamingSessionStreamResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.GetStreamingSessionStreamResponse
      .builder()
      .optionallyWith(stream.map(value => value.buildAwsValue()))(_.stream)
      .build()
  }
  def asReadOnly
      : zio.aws.nimble.model.GetStreamingSessionStreamResponse.ReadOnly =
    zio.aws.nimble.model.GetStreamingSessionStreamResponse.wrap(buildAwsValue())
}
object GetStreamingSessionStreamResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.GetStreamingSessionStreamResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.GetStreamingSessionStreamResponse =
      zio.aws.nimble.model.GetStreamingSessionStreamResponse(
        stream.map(value => value.asEditable)
      )
    def stream: Optional[zio.aws.nimble.model.StreamingSessionStream.ReadOnly]
    def getStream: ZIO[
      Any,
      AwsError,
      zio.aws.nimble.model.StreamingSessionStream.ReadOnly
    ] = AwsError.unwrapOptionField("stream", stream)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.GetStreamingSessionStreamResponse
  ) extends zio.aws.nimble.model.GetStreamingSessionStreamResponse.ReadOnly {
    override val stream
        : Optional[zio.aws.nimble.model.StreamingSessionStream.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stream())
        .map(value => zio.aws.nimble.model.StreamingSessionStream.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.GetStreamingSessionStreamResponse
  ): zio.aws.nimble.model.GetStreamingSessionStreamResponse.ReadOnly =
    new Wrapper(impl)
}
