package zio.aws.nimble.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.nimble.model.primitives.{
  LaunchProfileName,
  EC2SubnetId,
  LaunchProfileId,
  Timestamp,
  LaunchProfileDescription,
  LaunchProfileProtocolVersion
}
import scala.jdk.CollectionConverters._
final case class LaunchProfile(
    arn: Optional[String] = Optional.Absent,
    createdAt: Optional[Timestamp] = Optional.Absent,
    createdBy: Optional[String] = Optional.Absent,
    description: Optional[LaunchProfileDescription] = Optional.Absent,
    ec2SubnetIds: Optional[Iterable[EC2SubnetId]] = Optional.Absent,
    launchProfileId: Optional[LaunchProfileId] = Optional.Absent,
    launchProfileProtocolVersions: Optional[
      Iterable[LaunchProfileProtocolVersion]
    ] = Optional.Absent,
    name: Optional[LaunchProfileName] = Optional.Absent,
    state: Optional[zio.aws.nimble.model.LaunchProfileState] = Optional.Absent,
    statusCode: Optional[zio.aws.nimble.model.LaunchProfileStatusCode] =
      Optional.Absent,
    statusMessage: Optional[String] = Optional.Absent,
    streamConfiguration: Optional[zio.aws.nimble.model.StreamConfiguration] =
      Optional.Absent,
    studioComponentIds: Optional[Iterable[String]] = Optional.Absent,
    tags: Optional[Map[String, String]] = Optional.Absent,
    updatedAt: Optional[Timestamp] = Optional.Absent,
    updatedBy: Optional[String] = Optional.Absent,
    validationResults: Optional[
      Iterable[zio.aws.nimble.model.ValidationResult]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.LaunchProfile = {
    import LaunchProfile.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.LaunchProfile
      .builder()
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(createdBy.map(value => value: java.lang.String))(
        _.createdBy
      )
      .optionallyWith(
        description.map(value =>
          LaunchProfileDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        ec2SubnetIds.map(value =>
          value.map { item =>
            EC2SubnetId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.ec2SubnetIds)
      .optionallyWith(
        launchProfileId.map(value =>
          LaunchProfileId.unwrap(value): java.lang.String
        )
      )(_.launchProfileId)
      .optionallyWith(
        launchProfileProtocolVersions.map(value =>
          value.map { item =>
            LaunchProfileProtocolVersion.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.launchProfileProtocolVersions)
      .optionallyWith(
        name.map(value => LaunchProfileName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(statusCode.map(value => value.unwrap))(_.statusCode)
      .optionallyWith(statusMessage.map(value => value: java.lang.String))(
        _.statusMessage
      )
      .optionallyWith(streamConfiguration.map(value => value.buildAwsValue()))(
        _.streamConfiguration
      )
      .optionallyWith(
        studioComponentIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.studioComponentIds)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(updatedAt.map(value => Timestamp.unwrap(value): Instant))(
        _.updatedAt
      )
      .optionallyWith(updatedBy.map(value => value: java.lang.String))(
        _.updatedBy
      )
      .optionallyWith(
        validationResults.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.validationResults)
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.LaunchProfile.ReadOnly =
    zio.aws.nimble.model.LaunchProfile.wrap(buildAwsValue())
}
object LaunchProfile {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.LaunchProfile
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.LaunchProfile =
      zio.aws.nimble.model.LaunchProfile(
        arn.map(value => value),
        createdAt.map(value => value),
        createdBy.map(value => value),
        description.map(value => value),
        ec2SubnetIds.map(value => value),
        launchProfileId.map(value => value),
        launchProfileProtocolVersions.map(value => value),
        name.map(value => value),
        state.map(value => value),
        statusCode.map(value => value),
        statusMessage.map(value => value),
        streamConfiguration.map(value => value.asEditable),
        studioComponentIds.map(value => value),
        tags.map(value => value),
        updatedAt.map(value => value),
        updatedBy.map(value => value),
        validationResults.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def arn: Optional[String]
    def createdAt: Optional[Timestamp]
    def createdBy: Optional[String]
    def description: Optional[LaunchProfileDescription]
    def ec2SubnetIds: Optional[List[EC2SubnetId]]
    def launchProfileId: Optional[LaunchProfileId]
    def launchProfileProtocolVersions
        : Optional[List[LaunchProfileProtocolVersion]]
    def name: Optional[LaunchProfileName]
    def state: Optional[zio.aws.nimble.model.LaunchProfileState]
    def statusCode: Optional[zio.aws.nimble.model.LaunchProfileStatusCode]
    def statusMessage: Optional[String]
    def streamConfiguration
        : Optional[zio.aws.nimble.model.StreamConfiguration.ReadOnly]
    def studioComponentIds: Optional[List[String]]
    def tags: Optional[Map[String, String]]
    def updatedAt: Optional[Timestamp]
    def updatedBy: Optional[String]
    def validationResults
        : Optional[List[zio.aws.nimble.model.ValidationResult.ReadOnly]]
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getCreatedBy: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("createdBy", createdBy)
    def getDescription: ZIO[Any, AwsError, LaunchProfileDescription] =
      AwsError.unwrapOptionField("description", description)
    def getEc2SubnetIds: ZIO[Any, AwsError, List[EC2SubnetId]] =
      AwsError.unwrapOptionField("ec2SubnetIds", ec2SubnetIds)
    def getLaunchProfileId: ZIO[Any, AwsError, LaunchProfileId] =
      AwsError.unwrapOptionField("launchProfileId", launchProfileId)
    def getLaunchProfileProtocolVersions
        : ZIO[Any, AwsError, List[LaunchProfileProtocolVersion]] =
      AwsError.unwrapOptionField(
        "launchProfileProtocolVersions",
        launchProfileProtocolVersions
      )
    def getName: ZIO[Any, AwsError, LaunchProfileName] =
      AwsError.unwrapOptionField("name", name)
    def getState: ZIO[Any, AwsError, zio.aws.nimble.model.LaunchProfileState] =
      AwsError.unwrapOptionField("state", state)
    def getStatusCode
        : ZIO[Any, AwsError, zio.aws.nimble.model.LaunchProfileStatusCode] =
      AwsError.unwrapOptionField("statusCode", statusCode)
    def getStatusMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getStreamConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.nimble.model.StreamConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("streamConfiguration", streamConfiguration)
    def getStudioComponentIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("studioComponentIds", studioComponentIds)
    def getTags: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("tags", tags)
    def getUpdatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
    def getUpdatedBy: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("updatedBy", updatedBy)
    def getValidationResults: ZIO[Any, AwsError, List[
      zio.aws.nimble.model.ValidationResult.ReadOnly
    ]] = AwsError.unwrapOptionField("validationResults", validationResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.LaunchProfile
  ) extends zio.aws.nimble.model.LaunchProfile.ReadOnly {
    override val arn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: String)
    override val createdAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.nimble.model.primitives.Timestamp(value))
    override val createdBy: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.createdBy())
      .map(value => value: String)
    override val description: Optional[LaunchProfileDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.nimble.model.primitives.LaunchProfileDescription(value)
        )
    override val ec2SubnetIds: Optional[List[EC2SubnetId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ec2SubnetIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.nimble.model.primitives.EC2SubnetId(item)
          }.toList
        )
    override val launchProfileId: Optional[LaunchProfileId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.launchProfileId())
        .map(value => zio.aws.nimble.model.primitives.LaunchProfileId(value))
    override val launchProfileProtocolVersions
        : Optional[List[LaunchProfileProtocolVersion]] = zio.aws.core.internal
      .optionalFromNullable(impl.launchProfileProtocolVersions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.nimble.model.primitives.LaunchProfileProtocolVersion(item)
        }.toList
      )
    override val name: Optional[LaunchProfileName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.nimble.model.primitives.LaunchProfileName(value))
    override val state: Optional[zio.aws.nimble.model.LaunchProfileState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.nimble.model.LaunchProfileState.wrap(value))
    override val statusCode
        : Optional[zio.aws.nimble.model.LaunchProfileStatusCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusCode())
        .map(value => zio.aws.nimble.model.LaunchProfileStatusCode.wrap(value))
    override val statusMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.statusMessage())
      .map(value => value: String)
    override val streamConfiguration
        : Optional[zio.aws.nimble.model.StreamConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.streamConfiguration())
        .map(value => zio.aws.nimble.model.StreamConfiguration.wrap(value))
    override val studioComponentIds: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.studioComponentIds())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val tags: Optional[Map[String, String]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override val updatedAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedAt())
      .map(value => zio.aws.nimble.model.primitives.Timestamp(value))
    override val updatedBy: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedBy())
      .map(value => value: String)
    override val validationResults
        : Optional[List[zio.aws.nimble.model.ValidationResult.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.validationResults())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.nimble.model.ValidationResult.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.LaunchProfile
  ): zio.aws.nimble.model.LaunchProfile.ReadOnly = new Wrapper(impl)
}
