package zio.aws.nimble.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListEulasRequest(
    eulaIds: Optional[Iterable[String]] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.ListEulasRequest = {
    import ListEulasRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.ListEulasRequest
      .builder()
      .optionallyWith(
        eulaIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.eulaIds)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.ListEulasRequest.ReadOnly =
    zio.aws.nimble.model.ListEulasRequest.wrap(buildAwsValue())
}
object ListEulasRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.ListEulasRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.ListEulasRequest =
      zio.aws.nimble.model.ListEulasRequest(
        eulaIds.map(value => value),
        nextToken.map(value => value)
      )
    def eulaIds: Optional[List[String]]
    def nextToken: Optional[String]
    def getEulaIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("eulaIds", eulaIds)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.ListEulasRequest
  ) extends zio.aws.nimble.model.ListEulasRequest.ReadOnly {
    override val eulaIds: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.eulaIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.ListEulasRequest
  ): zio.aws.nimble.model.ListEulasRequest.ReadOnly = new Wrapper(impl)
}
