package zio.aws.nimble.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListStreamingImagesRequest(
    nextToken: Optional[String] = Optional.Absent,
    owner: Optional[String] = Optional.Absent,
    studioId: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.ListStreamingImagesRequest = {
    import ListStreamingImagesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.ListStreamingImagesRequest
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(owner.map(value => value: java.lang.String))(_.owner)
      .studioId(studioId: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.ListStreamingImagesRequest.ReadOnly =
    zio.aws.nimble.model.ListStreamingImagesRequest.wrap(buildAwsValue())
}
object ListStreamingImagesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.ListStreamingImagesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.ListStreamingImagesRequest =
      zio.aws.nimble.model.ListStreamingImagesRequest(
        nextToken.map(value => value),
        owner.map(value => value),
        studioId
      )
    def nextToken: Optional[String]
    def owner: Optional[String]
    def studioId: String
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getOwner: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("owner", owner)
    def getStudioId: ZIO[Any, Nothing, String] = ZIO.succeed(studioId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.ListStreamingImagesRequest
  ) extends zio.aws.nimble.model.ListStreamingImagesRequest.ReadOnly {
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val owner: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.owner())
      .map(value => value: String)
    override val studioId: String = impl.studioId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.ListStreamingImagesRequest
  ): zio.aws.nimble.model.ListStreamingImagesRequest.ReadOnly = new Wrapper(
    impl
  )
}
