package zio.aws.nimble.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListStreamingSessionBackupsRequest(
    nextToken: Optional[String] = Optional.Absent,
    ownedBy: Optional[String] = Optional.Absent,
    studioId: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.ListStreamingSessionBackupsRequest = {
    import ListStreamingSessionBackupsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.ListStreamingSessionBackupsRequest
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(ownedBy.map(value => value: java.lang.String))(_.ownedBy)
      .studioId(studioId: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.nimble.model.ListStreamingSessionBackupsRequest.ReadOnly =
    zio.aws.nimble.model.ListStreamingSessionBackupsRequest
      .wrap(buildAwsValue())
}
object ListStreamingSessionBackupsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.ListStreamingSessionBackupsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.ListStreamingSessionBackupsRequest =
      zio.aws.nimble.model.ListStreamingSessionBackupsRequest(
        nextToken.map(value => value),
        ownedBy.map(value => value),
        studioId
      )
    def nextToken: Optional[String]
    def ownedBy: Optional[String]
    def studioId: String
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getOwnedBy: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownedBy", ownedBy)
    def getStudioId: ZIO[Any, Nothing, String] = ZIO.succeed(studioId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.ListStreamingSessionBackupsRequest
  ) extends zio.aws.nimble.model.ListStreamingSessionBackupsRequest.ReadOnly {
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val ownedBy: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ownedBy())
      .map(value => value: String)
    override val studioId: String = impl.studioId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.ListStreamingSessionBackupsRequest
  ): zio.aws.nimble.model.ListStreamingSessionBackupsRequest.ReadOnly =
    new Wrapper(impl)
}
