package zio.aws.nimble.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListStudioComponentsResponse(
    nextToken: Optional[String] = Optional.Absent,
    studioComponents: Optional[Iterable[zio.aws.nimble.model.StudioComponent]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.ListStudioComponentsResponse = {
    import ListStudioComponentsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.ListStudioComponentsResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        studioComponents.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.studioComponents)
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.ListStudioComponentsResponse.ReadOnly =
    zio.aws.nimble.model.ListStudioComponentsResponse.wrap(buildAwsValue())
}
object ListStudioComponentsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.ListStudioComponentsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.ListStudioComponentsResponse =
      zio.aws.nimble.model.ListStudioComponentsResponse(
        nextToken.map(value => value),
        studioComponents.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[String]
    def studioComponents
        : Optional[List[zio.aws.nimble.model.StudioComponent.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getStudioComponents: ZIO[Any, AwsError, List[
      zio.aws.nimble.model.StudioComponent.ReadOnly
    ]] = AwsError.unwrapOptionField("studioComponents", studioComponents)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.ListStudioComponentsResponse
  ) extends zio.aws.nimble.model.ListStudioComponentsResponse.ReadOnly {
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val studioComponents
        : Optional[List[zio.aws.nimble.model.StudioComponent.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.studioComponents())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.nimble.model.StudioComponent.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.ListStudioComponentsResponse
  ): zio.aws.nimble.model.ListStudioComponentsResponse.ReadOnly = new Wrapper(
    impl
  )
}
