package zio.aws.nimble.model
import zio.aws.nimble.model.primitives.ClientToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PutStudioMembersRequest(
    clientToken: Optional[ClientToken] = Optional.Absent,
    identityStoreId: String,
    members: Iterable[zio.aws.nimble.model.NewStudioMember],
    studioId: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.PutStudioMembersRequest = {
    import PutStudioMembersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.PutStudioMembersRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .identityStoreId(identityStoreId: java.lang.String)
      .members(members.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .studioId(studioId: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.PutStudioMembersRequest.ReadOnly =
    zio.aws.nimble.model.PutStudioMembersRequest.wrap(buildAwsValue())
}
object PutStudioMembersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.PutStudioMembersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.PutStudioMembersRequest =
      zio.aws.nimble.model.PutStudioMembersRequest(
        clientToken.map(value => value),
        identityStoreId,
        members.map { item =>
          item.asEditable
        },
        studioId
      )
    def clientToken: Optional[ClientToken]
    def identityStoreId: String
    def members: List[zio.aws.nimble.model.NewStudioMember.ReadOnly]
    def studioId: String
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getIdentityStoreId: ZIO[Any, Nothing, String] =
      ZIO.succeed(identityStoreId)
    def getMembers: ZIO[Any, Nothing, List[
      zio.aws.nimble.model.NewStudioMember.ReadOnly
    ]] = ZIO.succeed(members)
    def getStudioId: ZIO[Any, Nothing, String] = ZIO.succeed(studioId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.PutStudioMembersRequest
  ) extends zio.aws.nimble.model.PutStudioMembersRequest.ReadOnly {
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.nimble.model.primitives.ClientToken(value))
    override val identityStoreId: String = impl.identityStoreId(): String
    override val members: List[zio.aws.nimble.model.NewStudioMember.ReadOnly] =
      impl
        .members()
        .asScala
        .map { item =>
          zio.aws.nimble.model.NewStudioMember.wrap(item)
        }
        .toList
    override val studioId: String = impl.studioId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.PutStudioMembersRequest
  ): zio.aws.nimble.model.PutStudioMembersRequest.ReadOnly = new Wrapper(impl)
}
