package zio.aws.nimble.model
import scala.jdk.CollectionConverters._
sealed trait SessionPersistenceMode {
  def unwrap
      : software.amazon.awssdk.services.nimble.model.SessionPersistenceMode
}
object SessionPersistenceMode {
  def wrap(
      value: software.amazon.awssdk.services.nimble.model.SessionPersistenceMode
  ): zio.aws.nimble.model.SessionPersistenceMode = value match {
    case software.amazon.awssdk.services.nimble.model.SessionPersistenceMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.nimble.model.SessionPersistenceMode.DEACTIVATED =>
      val r = DEACTIVATED
      r
    case software.amazon.awssdk.services.nimble.model.SessionPersistenceMode.ACTIVATED =>
      val r = ACTIVATED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.nimble.model.SessionPersistenceMode {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.SessionPersistenceMode =
      software.amazon.awssdk.services.nimble.model.SessionPersistenceMode.UNKNOWN_TO_SDK_VERSION
  }
  case object DEACTIVATED extends zio.aws.nimble.model.SessionPersistenceMode {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.SessionPersistenceMode =
      software.amazon.awssdk.services.nimble.model.SessionPersistenceMode.DEACTIVATED
  }
  case object ACTIVATED extends zio.aws.nimble.model.SessionPersistenceMode {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.SessionPersistenceMode =
      software.amazon.awssdk.services.nimble.model.SessionPersistenceMode.ACTIVATED
  }
}
