package zio.aws.nimble.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.nimble.model.primitives.{
  StreamingImageId,
  StreamingSessionId,
  StreamConfigurationMaxBackupsToRetain,
  Timestamp
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class StreamingSession(
    arn: Optional[String] = Optional.Absent,
    automaticTerminationMode: Optional[
      zio.aws.nimble.model.AutomaticTerminationMode
    ] = Optional.Absent,
    backupMode: Optional[zio.aws.nimble.model.SessionBackupMode] =
      Optional.Absent,
    createdAt: Optional[Timestamp] = Optional.Absent,
    createdBy: Optional[String] = Optional.Absent,
    ec2InstanceType: Optional[String] = Optional.Absent,
    launchProfileId: Optional[String] = Optional.Absent,
    maxBackupsToRetain: Optional[StreamConfigurationMaxBackupsToRetain] =
      Optional.Absent,
    ownedBy: Optional[String] = Optional.Absent,
    sessionId: Optional[StreamingSessionId] = Optional.Absent,
    sessionPersistenceMode: Optional[
      zio.aws.nimble.model.SessionPersistenceMode
    ] = Optional.Absent,
    startedAt: Optional[Timestamp] = Optional.Absent,
    startedBy: Optional[String] = Optional.Absent,
    startedFromBackupId: Optional[String] = Optional.Absent,
    state: Optional[zio.aws.nimble.model.StreamingSessionState] =
      Optional.Absent,
    statusCode: Optional[zio.aws.nimble.model.StreamingSessionStatusCode] =
      Optional.Absent,
    statusMessage: Optional[String] = Optional.Absent,
    stopAt: Optional[Timestamp] = Optional.Absent,
    stoppedAt: Optional[Timestamp] = Optional.Absent,
    stoppedBy: Optional[String] = Optional.Absent,
    streamingImageId: Optional[StreamingImageId] = Optional.Absent,
    tags: Optional[Map[String, String]] = Optional.Absent,
    terminateAt: Optional[Timestamp] = Optional.Absent,
    updatedAt: Optional[Timestamp] = Optional.Absent,
    updatedBy: Optional[String] = Optional.Absent,
    volumeConfiguration: Optional[zio.aws.nimble.model.VolumeConfiguration] =
      Optional.Absent,
    volumeRetentionMode: Optional[zio.aws.nimble.model.VolumeRetentionMode] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.StreamingSession = {
    import StreamingSession.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.StreamingSession
      .builder()
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(automaticTerminationMode.map(value => value.unwrap))(
        _.automaticTerminationMode
      )
      .optionallyWith(backupMode.map(value => value.unwrap))(_.backupMode)
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(createdBy.map(value => value: java.lang.String))(
        _.createdBy
      )
      .optionallyWith(ec2InstanceType.map(value => value: java.lang.String))(
        _.ec2InstanceType
      )
      .optionallyWith(launchProfileId.map(value => value: java.lang.String))(
        _.launchProfileId
      )
      .optionallyWith(
        maxBackupsToRetain.map(value =>
          StreamConfigurationMaxBackupsToRetain.unwrap(value): Integer
        )
      )(_.maxBackupsToRetain)
      .optionallyWith(ownedBy.map(value => value: java.lang.String))(_.ownedBy)
      .optionallyWith(
        sessionId.map(value =>
          StreamingSessionId.unwrap(value): java.lang.String
        )
      )(_.sessionId)
      .optionallyWith(sessionPersistenceMode.map(value => value.unwrap))(
        _.sessionPersistenceMode
      )
      .optionallyWith(startedAt.map(value => Timestamp.unwrap(value): Instant))(
        _.startedAt
      )
      .optionallyWith(startedBy.map(value => value: java.lang.String))(
        _.startedBy
      )
      .optionallyWith(
        startedFromBackupId.map(value => value: java.lang.String)
      )(_.startedFromBackupId)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(statusCode.map(value => value.unwrap))(_.statusCode)
      .optionallyWith(statusMessage.map(value => value: java.lang.String))(
        _.statusMessage
      )
      .optionallyWith(stopAt.map(value => Timestamp.unwrap(value): Instant))(
        _.stopAt
      )
      .optionallyWith(stoppedAt.map(value => Timestamp.unwrap(value): Instant))(
        _.stoppedAt
      )
      .optionallyWith(stoppedBy.map(value => value: java.lang.String))(
        _.stoppedBy
      )
      .optionallyWith(
        streamingImageId.map(value =>
          StreamingImageId.unwrap(value): java.lang.String
        )
      )(_.streamingImageId)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        terminateAt.map(value => Timestamp.unwrap(value): Instant)
      )(_.terminateAt)
      .optionallyWith(updatedAt.map(value => Timestamp.unwrap(value): Instant))(
        _.updatedAt
      )
      .optionallyWith(updatedBy.map(value => value: java.lang.String))(
        _.updatedBy
      )
      .optionallyWith(volumeConfiguration.map(value => value.buildAwsValue()))(
        _.volumeConfiguration
      )
      .optionallyWith(volumeRetentionMode.map(value => value.unwrap))(
        _.volumeRetentionMode
      )
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.StreamingSession.ReadOnly =
    zio.aws.nimble.model.StreamingSession.wrap(buildAwsValue())
}
object StreamingSession {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.StreamingSession
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.StreamingSession =
      zio.aws.nimble.model.StreamingSession(
        arn.map(value => value),
        automaticTerminationMode.map(value => value),
        backupMode.map(value => value),
        createdAt.map(value => value),
        createdBy.map(value => value),
        ec2InstanceType.map(value => value),
        launchProfileId.map(value => value),
        maxBackupsToRetain.map(value => value),
        ownedBy.map(value => value),
        sessionId.map(value => value),
        sessionPersistenceMode.map(value => value),
        startedAt.map(value => value),
        startedBy.map(value => value),
        startedFromBackupId.map(value => value),
        state.map(value => value),
        statusCode.map(value => value),
        statusMessage.map(value => value),
        stopAt.map(value => value),
        stoppedAt.map(value => value),
        stoppedBy.map(value => value),
        streamingImageId.map(value => value),
        tags.map(value => value),
        terminateAt.map(value => value),
        updatedAt.map(value => value),
        updatedBy.map(value => value),
        volumeConfiguration.map(value => value.asEditable),
        volumeRetentionMode.map(value => value)
      )
    def arn: Optional[String]
    def automaticTerminationMode
        : Optional[zio.aws.nimble.model.AutomaticTerminationMode]
    def backupMode: Optional[zio.aws.nimble.model.SessionBackupMode]
    def createdAt: Optional[Timestamp]
    def createdBy: Optional[String]
    def ec2InstanceType: Optional[String]
    def launchProfileId: Optional[String]
    def maxBackupsToRetain: Optional[StreamConfigurationMaxBackupsToRetain]
    def ownedBy: Optional[String]
    def sessionId: Optional[StreamingSessionId]
    def sessionPersistenceMode
        : Optional[zio.aws.nimble.model.SessionPersistenceMode]
    def startedAt: Optional[Timestamp]
    def startedBy: Optional[String]
    def startedFromBackupId: Optional[String]
    def state: Optional[zio.aws.nimble.model.StreamingSessionState]
    def statusCode: Optional[zio.aws.nimble.model.StreamingSessionStatusCode]
    def statusMessage: Optional[String]
    def stopAt: Optional[Timestamp]
    def stoppedAt: Optional[Timestamp]
    def stoppedBy: Optional[String]
    def streamingImageId: Optional[StreamingImageId]
    def tags: Optional[Map[String, String]]
    def terminateAt: Optional[Timestamp]
    def updatedAt: Optional[Timestamp]
    def updatedBy: Optional[String]
    def volumeConfiguration
        : Optional[zio.aws.nimble.model.VolumeConfiguration.ReadOnly]
    def volumeRetentionMode: Optional[zio.aws.nimble.model.VolumeRetentionMode]
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
    def getAutomaticTerminationMode
        : ZIO[Any, AwsError, zio.aws.nimble.model.AutomaticTerminationMode] =
      AwsError.unwrapOptionField(
        "automaticTerminationMode",
        automaticTerminationMode
      )
    def getBackupMode
        : ZIO[Any, AwsError, zio.aws.nimble.model.SessionBackupMode] =
      AwsError.unwrapOptionField("backupMode", backupMode)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getCreatedBy: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("createdBy", createdBy)
    def getEc2InstanceType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ec2InstanceType", ec2InstanceType)
    def getLaunchProfileId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("launchProfileId", launchProfileId)
    def getMaxBackupsToRetain
        : ZIO[Any, AwsError, StreamConfigurationMaxBackupsToRetain] =
      AwsError.unwrapOptionField("maxBackupsToRetain", maxBackupsToRetain)
    def getOwnedBy: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownedBy", ownedBy)
    def getSessionId: ZIO[Any, AwsError, StreamingSessionId] =
      AwsError.unwrapOptionField("sessionId", sessionId)
    def getSessionPersistenceMode
        : ZIO[Any, AwsError, zio.aws.nimble.model.SessionPersistenceMode] =
      AwsError.unwrapOptionField(
        "sessionPersistenceMode",
        sessionPersistenceMode
      )
    def getStartedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("startedAt", startedAt)
    def getStartedBy: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("startedBy", startedBy)
    def getStartedFromBackupId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("startedFromBackupId", startedFromBackupId)
    def getState
        : ZIO[Any, AwsError, zio.aws.nimble.model.StreamingSessionState] =
      AwsError.unwrapOptionField("state", state)
    def getStatusCode
        : ZIO[Any, AwsError, zio.aws.nimble.model.StreamingSessionStatusCode] =
      AwsError.unwrapOptionField("statusCode", statusCode)
    def getStatusMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getStopAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("stopAt", stopAt)
    def getStoppedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("stoppedAt", stoppedAt)
    def getStoppedBy: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("stoppedBy", stoppedBy)
    def getStreamingImageId: ZIO[Any, AwsError, StreamingImageId] =
      AwsError.unwrapOptionField("streamingImageId", streamingImageId)
    def getTags: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("tags", tags)
    def getTerminateAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("terminateAt", terminateAt)
    def getUpdatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
    def getUpdatedBy: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("updatedBy", updatedBy)
    def getVolumeConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.nimble.model.VolumeConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("volumeConfiguration", volumeConfiguration)
    def getVolumeRetentionMode
        : ZIO[Any, AwsError, zio.aws.nimble.model.VolumeRetentionMode] =
      AwsError.unwrapOptionField("volumeRetentionMode", volumeRetentionMode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.StreamingSession
  ) extends zio.aws.nimble.model.StreamingSession.ReadOnly {
    override val arn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: String)
    override val automaticTerminationMode
        : Optional[zio.aws.nimble.model.AutomaticTerminationMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.automaticTerminationMode())
        .map(value => zio.aws.nimble.model.AutomaticTerminationMode.wrap(value))
    override val backupMode: Optional[zio.aws.nimble.model.SessionBackupMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.backupMode())
        .map(value => zio.aws.nimble.model.SessionBackupMode.wrap(value))
    override val createdAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.nimble.model.primitives.Timestamp(value))
    override val createdBy: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.createdBy())
      .map(value => value: String)
    override val ec2InstanceType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ec2InstanceType())
      .map(value => value: String)
    override val launchProfileId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.launchProfileId())
      .map(value => value: String)
    override val maxBackupsToRetain
        : Optional[StreamConfigurationMaxBackupsToRetain] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxBackupsToRetain())
        .map(value =>
          zio.aws.nimble.model.primitives
            .StreamConfigurationMaxBackupsToRetain(value)
        )
    override val ownedBy: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ownedBy())
      .map(value => value: String)
    override val sessionId: Optional[StreamingSessionId] = zio.aws.core.internal
      .optionalFromNullable(impl.sessionId())
      .map(value => zio.aws.nimble.model.primitives.StreamingSessionId(value))
    override val sessionPersistenceMode
        : Optional[zio.aws.nimble.model.SessionPersistenceMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sessionPersistenceMode())
        .map(value => zio.aws.nimble.model.SessionPersistenceMode.wrap(value))
    override val startedAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.startedAt())
      .map(value => zio.aws.nimble.model.primitives.Timestamp(value))
    override val startedBy: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.startedBy())
      .map(value => value: String)
    override val startedFromBackupId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.startedFromBackupId())
      .map(value => value: String)
    override val state: Optional[zio.aws.nimble.model.StreamingSessionState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.nimble.model.StreamingSessionState.wrap(value))
    override val statusCode
        : Optional[zio.aws.nimble.model.StreamingSessionStatusCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusCode())
        .map(value =>
          zio.aws.nimble.model.StreamingSessionStatusCode.wrap(value)
        )
    override val statusMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.statusMessage())
      .map(value => value: String)
    override val stopAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.stopAt())
      .map(value => zio.aws.nimble.model.primitives.Timestamp(value))
    override val stoppedAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.stoppedAt())
      .map(value => zio.aws.nimble.model.primitives.Timestamp(value))
    override val stoppedBy: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.stoppedBy())
      .map(value => value: String)
    override val streamingImageId: Optional[StreamingImageId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.streamingImageId())
        .map(value => zio.aws.nimble.model.primitives.StreamingImageId(value))
    override val tags: Optional[Map[String, String]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override val terminateAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.terminateAt())
      .map(value => zio.aws.nimble.model.primitives.Timestamp(value))
    override val updatedAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedAt())
      .map(value => zio.aws.nimble.model.primitives.Timestamp(value))
    override val updatedBy: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedBy())
      .map(value => value: String)
    override val volumeConfiguration
        : Optional[zio.aws.nimble.model.VolumeConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.volumeConfiguration())
        .map(value => zio.aws.nimble.model.VolumeConfiguration.wrap(value))
    override val volumeRetentionMode
        : Optional[zio.aws.nimble.model.VolumeRetentionMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.volumeRetentionMode())
        .map(value => zio.aws.nimble.model.VolumeRetentionMode.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.StreamingSession
  ): zio.aws.nimble.model.StreamingSession.ReadOnly = new Wrapper(impl)
}
