package zio.aws.nimble.model
import scala.jdk.CollectionConverters._
sealed trait StreamingSessionState {
  def unwrap: software.amazon.awssdk.services.nimble.model.StreamingSessionState
}
object StreamingSessionState {
  def wrap(
      value: software.amazon.awssdk.services.nimble.model.StreamingSessionState
  ): zio.aws.nimble.model.StreamingSessionState = value match {
    case software.amazon.awssdk.services.nimble.model.StreamingSessionState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.nimble.model.StreamingSessionState.CREATE_IN_PROGRESS =>
      val r = CREATE_IN_PROGRESS
      r
    case software.amazon.awssdk.services.nimble.model.StreamingSessionState.DELETE_IN_PROGRESS =>
      val r = DELETE_IN_PROGRESS
      r
    case software.amazon.awssdk.services.nimble.model.StreamingSessionState.READY =>
      val r = READY
      r
    case software.amazon.awssdk.services.nimble.model.StreamingSessionState.DELETED =>
      val r = DELETED
      r
    case software.amazon.awssdk.services.nimble.model.StreamingSessionState.CREATE_FAILED =>
      val r = CREATE_FAILED
      r
    case software.amazon.awssdk.services.nimble.model.StreamingSessionState.DELETE_FAILED =>
      val r = DELETE_FAILED
      r
    case software.amazon.awssdk.services.nimble.model.StreamingSessionState.STOP_IN_PROGRESS =>
      val r = STOP_IN_PROGRESS
      r
    case software.amazon.awssdk.services.nimble.model.StreamingSessionState.START_IN_PROGRESS =>
      val r = START_IN_PROGRESS
      r
    case software.amazon.awssdk.services.nimble.model.StreamingSessionState.STOPPED =>
      val r = STOPPED
      r
    case software.amazon.awssdk.services.nimble.model.StreamingSessionState.STOP_FAILED =>
      val r = STOP_FAILED
      r
    case software.amazon.awssdk.services.nimble.model.StreamingSessionState.START_FAILED =>
      val r = START_FAILED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.nimble.model.StreamingSessionState {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StreamingSessionState =
      software.amazon.awssdk.services.nimble.model.StreamingSessionState.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATE_IN_PROGRESS
      extends zio.aws.nimble.model.StreamingSessionState {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StreamingSessionState =
      software.amazon.awssdk.services.nimble.model.StreamingSessionState.CREATE_IN_PROGRESS
  }
  case object DELETE_IN_PROGRESS
      extends zio.aws.nimble.model.StreamingSessionState {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StreamingSessionState =
      software.amazon.awssdk.services.nimble.model.StreamingSessionState.DELETE_IN_PROGRESS
  }
  case object READY extends zio.aws.nimble.model.StreamingSessionState {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StreamingSessionState =
      software.amazon.awssdk.services.nimble.model.StreamingSessionState.READY
  }
  case object DELETED extends zio.aws.nimble.model.StreamingSessionState {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StreamingSessionState =
      software.amazon.awssdk.services.nimble.model.StreamingSessionState.DELETED
  }
  case object CREATE_FAILED extends zio.aws.nimble.model.StreamingSessionState {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StreamingSessionState =
      software.amazon.awssdk.services.nimble.model.StreamingSessionState.CREATE_FAILED
  }
  case object DELETE_FAILED extends zio.aws.nimble.model.StreamingSessionState {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StreamingSessionState =
      software.amazon.awssdk.services.nimble.model.StreamingSessionState.DELETE_FAILED
  }
  case object STOP_IN_PROGRESS
      extends zio.aws.nimble.model.StreamingSessionState {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StreamingSessionState =
      software.amazon.awssdk.services.nimble.model.StreamingSessionState.STOP_IN_PROGRESS
  }
  case object START_IN_PROGRESS
      extends zio.aws.nimble.model.StreamingSessionState {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StreamingSessionState =
      software.amazon.awssdk.services.nimble.model.StreamingSessionState.START_IN_PROGRESS
  }
  case object STOPPED extends zio.aws.nimble.model.StreamingSessionState {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StreamingSessionState =
      software.amazon.awssdk.services.nimble.model.StreamingSessionState.STOPPED
  }
  case object STOP_FAILED extends zio.aws.nimble.model.StreamingSessionState {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StreamingSessionState =
      software.amazon.awssdk.services.nimble.model.StreamingSessionState.STOP_FAILED
  }
  case object START_FAILED extends zio.aws.nimble.model.StreamingSessionState {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StreamingSessionState =
      software.amazon.awssdk.services.nimble.model.StreamingSessionState.START_FAILED
  }
}
