package zio.aws.nimble.model
import scala.jdk.CollectionConverters._
sealed trait StudioStatusCode {
  def unwrap: software.amazon.awssdk.services.nimble.model.StudioStatusCode
}
object StudioStatusCode {
  def wrap(
      value: software.amazon.awssdk.services.nimble.model.StudioStatusCode
  ): zio.aws.nimble.model.StudioStatusCode = value match {
    case software.amazon.awssdk.services.nimble.model.StudioStatusCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.nimble.model.StudioStatusCode.STUDIO_CREATED =>
      val r = STUDIO_CREATED
      r
    case software.amazon.awssdk.services.nimble.model.StudioStatusCode.STUDIO_DELETED =>
      val r = STUDIO_DELETED
      r
    case software.amazon.awssdk.services.nimble.model.StudioStatusCode.STUDIO_UPDATED =>
      val r = STUDIO_UPDATED
      r
    case software.amazon.awssdk.services.nimble.model.StudioStatusCode.STUDIO_CREATE_IN_PROGRESS =>
      val r = STUDIO_CREATE_IN_PROGRESS
      r
    case software.amazon.awssdk.services.nimble.model.StudioStatusCode.STUDIO_UPDATE_IN_PROGRESS =>
      val r = STUDIO_UPDATE_IN_PROGRESS
      r
    case software.amazon.awssdk.services.nimble.model.StudioStatusCode.STUDIO_DELETE_IN_PROGRESS =>
      val r = STUDIO_DELETE_IN_PROGRESS
      r
    case software.amazon.awssdk.services.nimble.model.StudioStatusCode.STUDIO_WITH_LAUNCH_PROFILES_NOT_DELETED =>
      val r = STUDIO_WITH_LAUNCH_PROFILES_NOT_DELETED
      r
    case software.amazon.awssdk.services.nimble.model.StudioStatusCode.STUDIO_WITH_STUDIO_COMPONENTS_NOT_DELETED =>
      val r = STUDIO_WITH_STUDIO_COMPONENTS_NOT_DELETED
      r
    case software.amazon.awssdk.services.nimble.model.StudioStatusCode.STUDIO_WITH_STREAMING_IMAGES_NOT_DELETED =>
      val r = STUDIO_WITH_STREAMING_IMAGES_NOT_DELETED
      r
    case software.amazon.awssdk.services.nimble.model.StudioStatusCode.AWS_SSO_NOT_ENABLED =>
      val r = AWS_SSO_NOT_ENABLED
      r
    case software.amazon.awssdk.services.nimble.model.StudioStatusCode.AWS_SSO_ACCESS_DENIED =>
      val r = AWS_SSO_ACCESS_DENIED
      r
    case software.amazon.awssdk.services.nimble.model.StudioStatusCode.ROLE_NOT_OWNED_BY_STUDIO_OWNER =>
      val r = ROLE_NOT_OWNED_BY_STUDIO_OWNER
      r
    case software.amazon.awssdk.services.nimble.model.StudioStatusCode.ROLE_COULD_NOT_BE_ASSUMED =>
      val r = ROLE_COULD_NOT_BE_ASSUMED
      r
    case software.amazon.awssdk.services.nimble.model.StudioStatusCode.INTERNAL_ERROR =>
      val r = INTERNAL_ERROR
      r
    case software.amazon.awssdk.services.nimble.model.StudioStatusCode.ENCRYPTION_KEY_NOT_FOUND =>
      val r = ENCRYPTION_KEY_NOT_FOUND
      r
    case software.amazon.awssdk.services.nimble.model.StudioStatusCode.ENCRYPTION_KEY_ACCESS_DENIED =>
      val r = ENCRYPTION_KEY_ACCESS_DENIED
      r
    case software.amazon.awssdk.services.nimble.model.StudioStatusCode.AWS_SSO_CONFIGURATION_REPAIRED =>
      val r = AWS_SSO_CONFIGURATION_REPAIRED
      r
    case software.amazon.awssdk.services.nimble.model.StudioStatusCode.AWS_SSO_CONFIGURATION_REPAIR_IN_PROGRESS =>
      val r = AWS_SSO_CONFIGURATION_REPAIR_IN_PROGRESS
      r
    case software.amazon.awssdk.services.nimble.model.StudioStatusCode.AWS_STS_REGION_DISABLED =>
      val r = AWS_STS_REGION_DISABLED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.nimble.model.StudioStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StudioStatusCode =
      software.amazon.awssdk.services.nimble.model.StudioStatusCode.UNKNOWN_TO_SDK_VERSION
  }
  case object STUDIO_CREATED extends zio.aws.nimble.model.StudioStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StudioStatusCode =
      software.amazon.awssdk.services.nimble.model.StudioStatusCode.STUDIO_CREATED
  }
  case object STUDIO_DELETED extends zio.aws.nimble.model.StudioStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StudioStatusCode =
      software.amazon.awssdk.services.nimble.model.StudioStatusCode.STUDIO_DELETED
  }
  case object STUDIO_UPDATED extends zio.aws.nimble.model.StudioStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StudioStatusCode =
      software.amazon.awssdk.services.nimble.model.StudioStatusCode.STUDIO_UPDATED
  }
  case object STUDIO_CREATE_IN_PROGRESS
      extends zio.aws.nimble.model.StudioStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StudioStatusCode =
      software.amazon.awssdk.services.nimble.model.StudioStatusCode.STUDIO_CREATE_IN_PROGRESS
  }
  case object STUDIO_UPDATE_IN_PROGRESS
      extends zio.aws.nimble.model.StudioStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StudioStatusCode =
      software.amazon.awssdk.services.nimble.model.StudioStatusCode.STUDIO_UPDATE_IN_PROGRESS
  }
  case object STUDIO_DELETE_IN_PROGRESS
      extends zio.aws.nimble.model.StudioStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StudioStatusCode =
      software.amazon.awssdk.services.nimble.model.StudioStatusCode.STUDIO_DELETE_IN_PROGRESS
  }
  case object STUDIO_WITH_LAUNCH_PROFILES_NOT_DELETED
      extends zio.aws.nimble.model.StudioStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StudioStatusCode =
      software.amazon.awssdk.services.nimble.model.StudioStatusCode.STUDIO_WITH_LAUNCH_PROFILES_NOT_DELETED
  }
  case object STUDIO_WITH_STUDIO_COMPONENTS_NOT_DELETED
      extends zio.aws.nimble.model.StudioStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StudioStatusCode =
      software.amazon.awssdk.services.nimble.model.StudioStatusCode.STUDIO_WITH_STUDIO_COMPONENTS_NOT_DELETED
  }
  case object STUDIO_WITH_STREAMING_IMAGES_NOT_DELETED
      extends zio.aws.nimble.model.StudioStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StudioStatusCode =
      software.amazon.awssdk.services.nimble.model.StudioStatusCode.STUDIO_WITH_STREAMING_IMAGES_NOT_DELETED
  }
  case object AWS_SSO_NOT_ENABLED
      extends zio.aws.nimble.model.StudioStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StudioStatusCode =
      software.amazon.awssdk.services.nimble.model.StudioStatusCode.AWS_SSO_NOT_ENABLED
  }
  case object AWS_SSO_ACCESS_DENIED
      extends zio.aws.nimble.model.StudioStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StudioStatusCode =
      software.amazon.awssdk.services.nimble.model.StudioStatusCode.AWS_SSO_ACCESS_DENIED
  }
  case object ROLE_NOT_OWNED_BY_STUDIO_OWNER
      extends zio.aws.nimble.model.StudioStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StudioStatusCode =
      software.amazon.awssdk.services.nimble.model.StudioStatusCode.ROLE_NOT_OWNED_BY_STUDIO_OWNER
  }
  case object ROLE_COULD_NOT_BE_ASSUMED
      extends zio.aws.nimble.model.StudioStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StudioStatusCode =
      software.amazon.awssdk.services.nimble.model.StudioStatusCode.ROLE_COULD_NOT_BE_ASSUMED
  }
  case object INTERNAL_ERROR extends zio.aws.nimble.model.StudioStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StudioStatusCode =
      software.amazon.awssdk.services.nimble.model.StudioStatusCode.INTERNAL_ERROR
  }
  case object ENCRYPTION_KEY_NOT_FOUND
      extends zio.aws.nimble.model.StudioStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StudioStatusCode =
      software.amazon.awssdk.services.nimble.model.StudioStatusCode.ENCRYPTION_KEY_NOT_FOUND
  }
  case object ENCRYPTION_KEY_ACCESS_DENIED
      extends zio.aws.nimble.model.StudioStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StudioStatusCode =
      software.amazon.awssdk.services.nimble.model.StudioStatusCode.ENCRYPTION_KEY_ACCESS_DENIED
  }
  case object AWS_SSO_CONFIGURATION_REPAIRED
      extends zio.aws.nimble.model.StudioStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StudioStatusCode =
      software.amazon.awssdk.services.nimble.model.StudioStatusCode.AWS_SSO_CONFIGURATION_REPAIRED
  }
  case object AWS_SSO_CONFIGURATION_REPAIR_IN_PROGRESS
      extends zio.aws.nimble.model.StudioStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StudioStatusCode =
      software.amazon.awssdk.services.nimble.model.StudioStatusCode.AWS_SSO_CONFIGURATION_REPAIR_IN_PROGRESS
  }
  case object AWS_STS_REGION_DISABLED
      extends zio.aws.nimble.model.StudioStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StudioStatusCode =
      software.amazon.awssdk.services.nimble.model.StudioStatusCode.AWS_STS_REGION_DISABLED
  }
}
