package zio.aws.nimble.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetStudioComponentRequest(
    studioComponentId: String,
    studioId: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.GetStudioComponentRequest = {
    import GetStudioComponentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.GetStudioComponentRequest
      .builder()
      .studioComponentId(studioComponentId: java.lang.String)
      .studioId(studioId: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.GetStudioComponentRequest.ReadOnly =
    zio.aws.nimble.model.GetStudioComponentRequest.wrap(buildAwsValue())
}
object GetStudioComponentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.GetStudioComponentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.GetStudioComponentRequest =
      zio.aws.nimble.model
        .GetStudioComponentRequest(studioComponentId, studioId)
    def studioComponentId: String
    def studioId: String
    def getStudioComponentId: ZIO[Any, Nothing, String] =
      ZIO.succeed(studioComponentId)
    def getStudioId: ZIO[Any, Nothing, String] = ZIO.succeed(studioId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.GetStudioComponentRequest
  ) extends zio.aws.nimble.model.GetStudioComponentRequest.ReadOnly {
    override val studioComponentId: String = impl.studioComponentId(): String
    override val studioId: String = impl.studioId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.GetStudioComponentRequest
  ): zio.aws.nimble.model.GetStudioComponentRequest.ReadOnly = new Wrapper(impl)
}
