package zio.aws.nimble.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.nimble.model.primitives.MaxResults
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListLaunchProfilesRequest(
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent,
    principalId: Optional[String] = Optional.Absent,
    states: Optional[Iterable[zio.aws.nimble.model.LaunchProfileState]] =
      Optional.Absent,
    studioId: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.ListLaunchProfilesRequest = {
    import ListLaunchProfilesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.ListLaunchProfilesRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(principalId.map(value => value: java.lang.String))(
        _.principalId
      )
      .optionallyWith(
        states.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.statesWithStrings)
      .studioId(studioId: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.ListLaunchProfilesRequest.ReadOnly =
    zio.aws.nimble.model.ListLaunchProfilesRequest.wrap(buildAwsValue())
}
object ListLaunchProfilesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.ListLaunchProfilesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.ListLaunchProfilesRequest =
      zio.aws.nimble.model.ListLaunchProfilesRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        principalId.map(value => value),
        states.map(value => value),
        studioId
      )
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[String]
    def principalId: Optional[String]
    def states: Optional[List[zio.aws.nimble.model.LaunchProfileState]]
    def studioId: String
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getPrincipalId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("principalId", principalId)
    def getStates
        : ZIO[Any, AwsError, List[zio.aws.nimble.model.LaunchProfileState]] =
      AwsError.unwrapOptionField("states", states)
    def getStudioId: ZIO[Any, Nothing, String] = ZIO.succeed(studioId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.ListLaunchProfilesRequest
  ) extends zio.aws.nimble.model.ListLaunchProfilesRequest.ReadOnly {
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.nimble.model.primitives.MaxResults(value))
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val principalId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.principalId())
      .map(value => value: String)
    override val states
        : Optional[List[zio.aws.nimble.model.LaunchProfileState]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.states())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.nimble.model.LaunchProfileState.wrap(item)
          }.toList
        )
    override val studioId: String = impl.studioId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.ListLaunchProfilesRequest
  ): zio.aws.nimble.model.ListLaunchProfilesRequest.ReadOnly = new Wrapper(impl)
}
